/* $NetBSD: $ */

/*-
  * Copyright (c) 2009 UPMC/LIP6
  * All rights reserved.
  * This software is distributed under the following condiions
  * compliant with the NetBSD foundation policy.
  *
  * Redistribution and use in source and binary forms, with or without
  * modification, are permitted provided that the following conditions
  * are met:
  * 1. Redistributions of source code must retain the above copyright
  *    notice, this list of conditions and the following disclaimer.
  * 2. Redistributions in binary form must reproduce the above copyright
  *    notice, this list of conditions and the following disclaimer in the
  *    documentation and/or other materials provided with the distribution.
  *
  * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
  * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
  * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
  * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
  * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  * POSSIBILITY OF SUCH DAMAGE.
  */

#include <sys/cdefs.h>

#include <machine/param.h>
#include <mips/asm.h>
#include <mips/cpuregs.h>
#include <mips/trap.h>

#include <machine/bootinfo.h>

#include "assym.h"

#define _RELOC(x)       ((x) - KERNBASE)
#define RELOC(x)        _RELOC(_C_LABEL(x))

#define TTY_BASE 0xd0200000
#define TTY_WRITE 0

	.set	noreorder

	.text
	.globl	start
	.globl	_C_LABEL(kernel_text)
# void start(void *bi)
start:
_C_LABEL(kernel_text):
	mtc0	zero, MIPS_COP_0_STATUS	#disable interrupts
	COP0_SYNC

	/* intialize stack */
	la	sp, RELOC(tmpsk)
#ifdef __GP_SUPPORT__
	la	gp, RELOC(_gp)
#endif
	mfc0	t0, MIPS_COP_0_PRID #read product revision ID
	sw	t0, RELOC(cpu_id)

	move	s0, a0

	la	a0, RELOC(edata)
	move	a1, zero
	la	a2, RELOC(end)
	jal	_C_LABEL(memset) # memset(edata, 0, end - edata)
	subu	a2, a2, a0

	la k0, TTY_BASE
	li a0, 'A'
	sb a0, TTY_WRITE(k0)

	move	a1, s0
	la 	a0, RELOC(bootinfo)
	jal	_C_LABEL(memcpy) # memcpy(&bootinfo, bi, BOOTINFO_SIZE)
	li	a2, BOOTINFO_SIZE

	la a0, TTY_BASE
	la a1, RELOC(mtty_consolev)
	sw a0, 0(a1)
	la a1, RELOC(mtty_consolep)
	sw a0, 0(a1) #mttycn_putc works now

	#build L1 PTE
	move	a1, zero
	la	a0, RELOC(kernelpd)
	jal	_C_LABEL(memset) # memset(kernelpd, 0, PAGE_SIZE * 2)
	li	a2, PAGE_SIZE * 2

	/* important registers
	 * s0: kernel mapping size (in page)
	 * s1: kernel virtual start
	 * s2: kernel physical start
	 * s3: kernelpd address
	 */
	la	s1, start
	li	t0, PTE1_FRAME
	and	s1, s1, t0 # align s1 to 2M
	la	s2, RELOC(start)
	la	s0, _end
	subu	s0, s0, s1  # s0 - s1 -> s0 size of mapping
	li	t0, ((1 << PTE1_SHIFT) - 1)
	addu	s0, t0, s0 # round up
	srl	s0, s0, PTE1_SHIFT # number of pages
	addiu	t0, s0, '0';
	sb	t0, TTY_WRITE(k0)
	la	s3, RELOC(kernelpd)
	move	a0, s2
	move	a1, s0
	move	a2, s2
	jal	pmap_bootstrap_map  # map(s2, s0, s2, s3)
	move	a3, s3
	
	la	t0, 'x'
	sb	t0, TTY_WRITE(k0)
	move	a0, s2
	move	a1, s0
	move	a2, s1
	jal	pmap_bootstrap_map # map(s2, s0, s1, s3)
	move	a3, s3

	la	t0, 'y'
	sb	t0, TTY_WRITE(k0)
	la	a0, TTY_BASE
	li	a1, 1
	move	a2, a0
	jal	pmap_bootstrap_map # map(TTY_BASE, 1, TTY_BASE, s3)
	move a3, s3

	li	t0, 'B'
	sb	t0, TTY_WRITE(k0)
	move	a0, zero

	/* enable MMU */
	la	a0, RELOC(kernelpd);
	srl	a0, a0, VC_PTPR_PASHIFT
	move	s1, a0
	jal	_C_LABEL(printx)
	nop
	mtc2	s1, $VC_PTPR, 0
	li	t0, (VC_TLB_EN_ITLB | VC_TLB_EN_DTLB | VC_TLB_EN_ICACHE | VC_TLB_EN_DCACHE)
	mtc2	t0, $VC_TLB_EN, 0

	li	t0, 'E'
	sb	t0, TTY_WRITE(k0)
	/* MMU running, jump to virtual address */
	la	t0, _C_LABEL(virtal)
	jr	t0
virtal:
	li	t0, 'F'
	sb	t0, TTY_WRITE(k0)
	la	sp, tmpsk
#ifdef __GP_SUPPORT__
        la      gp, _gp
#endif
	move	a0, sp
	jal printx
	nop
	/* now running in virtual mode, remove identity mapping */
	move	a0, zero
	move	a1, s0
	move	a2, s2
	la	a3, _C_LABEL(kernelpd)
	jal	pmap_bootstrap_map # pmap_bootstrap_map(0, s0, s2, &kernelpd)
	nop
	li	t0, 'H'
	sb	t0, TTY_WRITE(k0)

	/* set curlwp and curcpu */
	la	MIPS_CURLWP, _C_LABEL(lwp0)
	la	t0, _C_LABEL(cpu_info_store)
	sw	MIPS_CURLWP, CPU_INFO_CURLWP(t0)
	sw	t0, L_CPU(MIPS_CURLWP)

	/* finish low-level init */
	jal mach_init # mach_init(void)
	nop

	/* switch to lwp0 stack now ? should do it before ? */
	lw      sp, _C_LABEL(proc0paddr)
	nop
	addu    sp, sp, USPACE - FRAME_SIZ - CALLFRAME_SIZ
	li	t0, 'D'
	sb	t0, TTY_WRITE(k0)
	move	a0, sp
	jal	printx
	nop
	jal	_C_LABEL(main)	# main(void)
	nop
	PANIC("main() returned")
	.set at
	.globl _C_LABEL(verylocore)
_C_LABEL(verylocore):

/*
 * u_int32_t mips_cp0_ebase_read(void)
 *
 *      Return the current value of the CP0 Ebase register.
 */
LEAF(mips_cp0_ebase_read)
        mfc0    v0, MIPS_COP_0_EBASE, 1
	j       ra
	nop
END(mips_cp0_ebase_read)

/*
 * void mips_cp0_ebase_write(u_int32_t)
 * 
 *      Set the value of the CP0 Ebase register.
 *
 */
LEAF(mips_cp0_ebase_write)
        mtc0    a0, MIPS_COP_0_EBASE, 1
        COP0_SYNC
        nop
        nop
        j       ra
        nop
END(mips_cp0_ebase_write)

	.sdata
	.globl  _C_LABEL(esym)
_C_LABEL(esym):
	.word 0

        .globl  _C_LABEL(cpu_id)
	.globl  _C_LABEL(fpu_id)
_C_LABEL(cpu_id):
	.word   0
_C_LABEL(fpu_id):
	.word   0


	.bss
        .space 508
tmpsk:  .space 4
	.globl _C_LABEL(bootinfo)
_C_LABEL(bootinfo):
	.space BOOTINFO_SIZE

	.globl _C_LABEL(kernelpd)
	.align (PAGE_SHIFT + 1)
_C_LABEL(kernelpd):
	.space PAGE_SIZE * 2
