/*	$NetBSD: cpuset.h,v 1.1.2.2 2011/04/29 08:26:20 matt Exp $	*/
/*	$NetBSD: cpuset.h,v 1.1.2.2 2011/04/29 08:26:20 matt Exp $ */

/*-
 * Copyright (c) 2004 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _TSARMIPS_CPUSET_H_
#define	_TSARMIPS_CPUSET_H_

#include <sys/atomic.h>

#define __CPUSET_SINGLE(cpu)		(1 << __CPUSET_E_SHIFT(cpu))

#define	CPUSET_ADD(set, cpu)		\
    atomic_or_32(&(set).cpuset[__CPUSET_E_IDX(cpu)], __CPUSET_SINGLE(cpu))
#define	CPUSET_DEL(set, cpu)		\
    atomic_and_32(&(set).cpuset[__CPUSET_E_IDX(cpu)], ~__CPUSET_SINGLE(cpu))

static inline void
CPUSET_SUB(__cpuset_t set1, __cpuset_t set2)
{
	int i;
	for (i = 0; i < __CPUSET_E_IDX(__CPUSET_MAXNUMCPU); i++) {
		atomic_and_32(&(set1).cpuset[i], ~(set2).cpuset[i]);
	}
}

#define	CPUSET_HAS_P(set, cpu)		\
	(((set).cpuset[__CPUSET_E_IDX(cpu)] & __CPUSET_SINGLE(cpu)) != 0)

static inline int
CPUSET_NEXT(__cpuset_t set)
{
	int i;
	for (i = 0; i < __CPUSET_E_IDX(__CPUSET_MAXNUMCPU); i++) {
		if (set.cpuset[i] != 0) {
			return (ffs(set.cpuset[i]) - 1 + i * __CPUSET_E_NUMCPU);
		}
	}
	return -1;
}

static inline bool
CPUSET_EMPTY_P(__cpuset_t set)
{
	int i;
	for (i = 0; i < __CPUSET_E_IDX(__CPUSET_MAXNUMCPU); i++) {
		if (set.cpuset[i] != 0) {
			return false;
		}
	}
	return true;
}

static inline bool
CPUSET_EQUAL_P(__cpuset_t set1, __cpuset_t set2)
{
	int i;
	for (i = 0; i < __CPUSET_E_IDX(__CPUSET_MAXNUMCPU); i++) {
		if (set1.cpuset[i] != set2.cpuset[i]) {
			return false;
		}
	}
	return true;
	
}

#define	CPUSET_CLEAR(set)		\
	(memset(__UNVOLATILE(&(set)), 0, sizeof(__cpuset_t)))
#define	CPUSET_ASSIGN(set1, set2)	((set1) = (set2))

#endif /* _TSARMIPS_CPUSET_H_ */
