/*	$NetBSD: boot1.c,v 1.17 2008/04/30 16:18:26 ad Exp $	*/

/*-
 * Copyright (c) 2003 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by David Laight.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/cdefs.h>
__RCSID("$NetBSD: boot1.c,v 1.17 2008/04/30 16:18:26 ad Exp $");

#include <lib/libsa/stand.h>
#include <lib/libkern/libkern.h>

#include <sys/param.h>
#include <sys/bootblock.h>
#include <sys/disklabel.h>
#include <dev/raidframe/raidframevar.h>	/* For RF_PROTECTED_SECTORS */
#include <machine/tsar_firmware.h>

#define XSTR(x) #x
#define STR(x) XSTR(x)

void boot1(void);
static void putstr(const char *);
static void error(const char *);

struct disklabel ptn_disklabel;
int start_sector;

static int
ob(void)
{
	return open("boot", 0);
}

static void
putstr(const char *buf)
{
	while (*buf != NULL) {
		TFI_DATA->tfi_putc(*buf);
		buf++;
	}
}

#if 1
static void puthex(int);
static void
puthex(int i)
{
	static const char c[] = "0123456789abcdef";
	char _buf[9], *buf = &_buf[9];

	*buf = 0;
	buf--;
	putstr("0x");
	for(;;) {
		*buf = c[i & 0xf];
		i = i >> 4;
		if (i == 0)
			break;
		buf--;
	}
	putstr(buf);
}
#endif

static void
error(const char *s)
{
	putstr(s);
	while (1)
		;
}
		
void
boot1()
{
        struct stat sb;
	int fd;
	int size;

	start_sector = 0;
        putstr("\nNetBSD/tsarmips " STR(FS) " Primary Bootstrap\n");

	fd = ob();
	if (fd != -1)
		goto done;

#if 0
	/*
	 * Maybe the filesystem is enclosed in a raid set.
	 * add in size of raidframe header and try again.
	 * (Maybe this should only be done if the filesystem
	 * magic number is absent.)
	 */
	start_sector += RF_PROTECTED_SECTORS;
	fd = ob();
	if (fd != -1)
		goto done;
	/*
	 * Nothing at the start of the disk, fallback on
	 * partition 'a' from the disklabel in this MBR partition.
	 */
	if (ptn_disklabel.d_magic != DISKMAGIC ||
	    ptn_disklabel.d_magic2 != DISKMAGIC ||
	    ptn_disklabel.d_partitions[0].p_fstype == FS_UNUSED)
		goto done;
	start_sector = ptn_disklabel.d_partitions[0].p_offset;
	if (ptn_disklabel.d_partitions[0].p_fstype == FS_RAID)
		start_sector += RF_PROTECTED_SECTORS;

	fd = ob();
#endif
done:
	/* if we fail here, so will fstat, so keep going */
	if (fstat(fd, &sb) == -1)
		error("Can't open /boot\n");

	size = (uint32_t)sb.st_size;

	if (size < TSAR_SECTSIZE)
		error("/boot too small\n");

	if (read(fd, (void *)SECONDARY_LOAD_ADDRESS, size) != size)
		error("/boot load failed\n");

#if 0
	if (*(uint32_t *)(SECONDARY_LOAD_ADDRESS + 4) != TSAR_BOOT_MAGIC_2)
		error("Invalid /boot file format\n");
#endif

	/* Now jump to the secondary bootstrap */
	puthex(size);
	error(" really ?\n");
	return;
}

int
blkdevstrategy(void *devdata, int flag, daddr_t dblk, size_t size, void *buf, size_t *rsize)
{
	if (flag != F_READ)
		return EROFS;

	if (size & (TSAR_SECTSIZE - 1))
		return EINVAL;

	if (rsize)
		*rsize = size;

	if (size != 0 && TFI_DATA->tfi_read(start_sector + dblk, buf,
	    size / TSAR_SECTSIZE) != 0)
		return EIO;

	return 0;
}
