/* $NetBSD: $ */
/*-
  * Copyright (c) 2012 UPMC/LIP6
  * All rights reserved.
  * This software is distributed under the following condiions
  * compliant with the NetBSD foundation policy.
  *
  * Redistribution and use in source and binary forms, with or without
  * modification, are permitted provided that the following conditions
  * are met:
  * 1. Redistributions of source code must retain the above copyright
  *    notice, this list of conditions and the following disclaimer.
  * 2. Redistributions in binary form must reproduce the above copyright
  *    notice, this list of conditions and the following disclaimer in the
  *    documentation and/or other materials provided with the distribution.
  *
  * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
  * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
  * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
  * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
  * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  * POSSIBILITY OF SUCH DAMAGE.
  */

#include <mips/asm.h>
#include <mips/cpuregs.h>
#include <sys/bootblock.h>

/*
 * Code linked to 0x1000 and copied to sectors 2+ of the netbsd boot
 * partition by MI /usr/sbin/installboot.
 * Read into memory by rom code.
 */
	.text
	.globl	start
start:
	.set noreorder
	.set mips32
#ifdef __GP_SUPPORT__
        la      gp, _C_LABEL (_gp)
#endif
	la	sp, _C_LABEL(stk)
	la	a0, _C_LABEL (edata)
	la	a2, _C_LABEL(end)	# memset(edata, 0, end - edata)
1:					# but inline, stack is in bss !
	sw	zero, 0(a0)
	addiu	a0, a0, 4
	bne	a0, a2, 1b
	nop

	jal	_C_LABEL(boot1)
	nop

	la	v0, SECONDARY_LOAD_ADDRESS
	jr	v0
	nop

	.text
	.global xxfs_open
	.global xxfs_close
	.global xxfs_read
	.global xxfs_stat
xxfs_open:
	j	XXfs_open
	nop
xxfs_close:
	j	XXfs_close
	nop
xxfs_read:
	j	XXfs_read
	nop
xxfs_stat:
	j	XXfs_stat
	nop

	.bss
	.space 2044
stk:	.space 4
