#include <machine/bootinfo.h>
#include <machine/vcacheregs.h>
#include <mips/asm.h>
#include <mips/cpuregs.h>
#include "tty.h"
#include "xicu.h"

	.text
	.globl  start
start:
	.set noreorder
	.set mips32
	b       _start		#0xbfc00000
	nop			#0xbfc00004
	.word   0x00010001	#0xbfc00008
	.word   0xbfd00000	#0xbfc0000c
	.word   putchar		#0xbfc00010
	.word   0x0		#0xbfc00014
	.word   0x0		#0xbfc00018

_start:
#ifdef __GP_SUPPORT__
        la	gp, _C_LABEL (_gp)
#endif
#if 0
	li	t0, (VC_TLB_EN_ICACHE | VC_TLB_EN_DCACHE)
	mtc2	t0, $VC_TLB_EN, 0
#endif

	mfc0	a0, MIPS_COP_0_EBASE, 1
	andi	a0, a0, 0x1ff
	bne	a0, zero, seccpu
	nop

	li	a0, 'D'
	la	a1, TTY_BASE
	sb	a0, TTY_WRITE(a1)
	la	sp, _C_LABEL(stk)	#setup stack
	la	a0, _C_LABEL (edata)
	move	a1, zero
	la	a2, _C_LABEL(end)	# memset(edata, 0, end - edata)
	jal	_C_LABEL(memset)
	subu	a2, a2, a0

	li	a0, 'E'
	la	a1, TTY_BASE
	sb	a0, TTY_WRITE(a1)
	jal	_C_LABEL(main)
	nop
	li	a0, 'F'
	la	a1, TTY_BASE
	sb	a0, TTY_WRITE(a1)
l:
	j	l

seccpu:
	#a0 has the CPU index
	addi	t0, a0, '0';
	la	t1, TTY_BASE
	sb	t0, TTY_WRITE(t1)

	sll	a0, a0, 2	# a0 = CPUID * 4
	li	a1,  XICU_BASE
	addu	a1, a0, a1	# a1 = XICU_WTI_REG(local_id)
1:
	lw	t0, 0(a1) 
	beq	t0, zero, 1b
	nop
	#CPU woken up, jump to address specified in mailbox
	jr	t0
	nop

	.data
	.global stk
	.space 1024		# 512 bytes for stack
stk:	.space 1
