/* $NetBSD: $ */

/*-
  * Copyright (c) 2010 UPMC/LIP6
  * All rights reserved.
  * This software is distributed under the following condiions
  * compliant with the NetBSD foundation policy.
  *
  * Redistribution and use in source and binary forms, with or without
  * modification, are permitted provided that the following conditions
  * are met:
  * 1. Redistributions of source code must retain the above copyright
  *    notice, this list of conditions and the following disclaimer.
  * 2. Redistributions in binary form must reproduce the above copyright
  *    notice, this list of conditions and the following disclaimer in the
  *    documentation and/or other materials provided with the distribution.
  *
  * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
  * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
  * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
  * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
  * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  * POSSIBILITY OF SUCH DAMAGE.
  */

/* driver for soclib's ahci disk controller */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: machdep.c,v 1.223 2008/07/02 17:28:56 ad Exp $");

#include <sys/param.h>
#include <sys/proc.h>
#include <sys/systm.h>
#include <sys/device.h>
#include <sys/conf.h>

#include <uvm/uvm_extern.h>

#include <machine/autoconf.h>
#include <machine/bus.h>

#include <dev/ata/atavar.h>
#include <dev/ic/ahcisatavar.h>

static int ahcisata_vci_match(device_t, cfdata_t, void *);
static void ahcisata_vci_attach(device_t, device_t, void *);

struct ahcisata_vci_softc {
	struct ahci_softc ah_sc;
	irq_t sc_ih;
};

CFATTACH_DECL_NEW(ahcisata_vci, sizeof(struct ahcisata_vci_softc),
    ahcisata_vci_match, ahcisata_vci_attach, NULL, NULL);

int
ahcisata_vci_match(device_t parent, cfdata_t match, void *aux)
{
	struct tsardevs_attach_args *tsd = aux;
	if (strcmp(tsd->tsd_devtype, "soclib:ahci") != 0)
		return 0;
	return 1;
}

void
ahcisata_vci_attach(device_t parent, device_t self, void *aux)
{
	struct ahcisata_vci_softc *vsc = device_private(self);
	struct ahci_softc *sc = &vsc->ah_sc;
	struct tsardevs_attach_args *tsd = aux;
	char buf[40];

	sc->sc_atac.atac_dev = self;

	aprint_normal(": VCI ahci disk controller\n");

	sc->sc_dmat = tsd->tsd_dmatag;
	sc->sc_ahcit = tsd->tsd_tag;

	/* map the device */
	if (bus_space_map(sc->sc_ahcit,
	    tsd->tsd_reg[0].reg_addr,tsd->tsd_reg[0].reg_size, 0,
	    &sc->sc_ahcih)) {
			aprint_error_dev(self, "couldn't map registers\n");
			return;
	}
	vsc->sc_ih = intr_establish(tsd->tsd_xicu,
	    IRQ_HWI, tsd->tsd_irq, IPL_BIO,
	    device_xname(self), buf, ahci_intr, sc, NULL);
	if (vsc->sc_ih == NULL) {
		aprint_error_dev(self, "can't establish interrupt\n");
		return;
	} else {
		aprint_normal_dev(self, "interrupting at %s\n", buf);
	}
	ahci_attach(sc);
}
