/* $NetBSD: $ */

/*-
  * Copyright (c) 2009 UPMC/LIP6
  * All rights reserved.
  * This software is distributed under the following condiions
  * compliant with the NetBSD foundation policy.
  *
  * Redistribution and use in source and binary forms, with or without
  * modification, are permitted provided that the following conditions
  * are met:
  * 1. Redistributions of source code must retain the above copyright
  *    notice, this list of conditions and the following disclaimer.
  * 2. Redistributions in binary form must reproduce the above copyright
  *    notice, this list of conditions and the following disclaimer in the
  *    documentation and/or other materials provided with the distribution.
  *
  * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
  * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
  * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
  * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
  * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  * POSSIBILITY OF SUCH DAMAGE.
  */

#ifndef _TSARMIPS_VCACHEREGS_H_
#define _TSARMIPS_VCACHEREGS_H_

/* register definitions of the vcache */
#define VC_PTPR 	0 /* set Page Table Pointer Register */
#define   VC_PTPR_PASHIFT  13
#define VC_TLB_EN 	1 /* set Data & Inst TLBs Mode Register */
#define   VC_TLB_EN_ITLB    0x8 /* enable instruction TLB */
#define   VC_TLB_EN_DTLB    0x4 /* enable data TLB */
#define   VC_TLB_EN_ICACHE  0x2 /* enable instruction cache */
#define   VC_TLB_EN_DCACHE  0x1 /* enable data cache */
#define VC_ICACHE_FLUSH 2 /* Instruction Cache flush */
#define VC_DCACHE_FLUSH 3 /* Data Cache flush */
#define VC_ITLB_INVAL 	4 /* Instruction TLB line invalidate */
#define VC_DTLB_INVAL 	5 /* Data TLB line invalidate */
#define VC_ICACHE_INVAL 6 /* Instruction Cache line invalidate */
#define VC_DCACHE_INVAL 7 /* Data Cache line invalidate */
#define VC_ICACHE_PREFETCH 8 /* Instruction Cache line prefetch */
#define VC_DCACHE_PREFETCH 9 /* Data Cache line prefetch */
#define VC_SYNC		10 /* Complete pending writes */
#define VC_IERR_TYPE 	11 /* Instruction Exception type Register */
#define VC_DERR_TYPE 	12 /* Data Exception type Register */
#define   VC_ERR_PT1_UNMAPPED		0x001 /* Page fault on Table1 (invalid PTE) */
#define   VC_ERR_PT2_UNMAPPED		0x002 /* Page fault on Table 2 (invalid PTE) */
#define   VC_ERR_PRIVILEGE_VIOLATION 	0x004 /* Protected access in user mode */
#define   VC_ERR_WRITE_VIOLATION 	0x008 /* Write access to a non write page */
#define   VC_ERR_EXEC_VIOLATION 	0x010 /* Exec access to a non exec page */
#define   VC_ERR_UNDEFINED_XTN 		0x020 /* Undefined external access address */
#define   VC_ERR_PT1_ILLEGAL_ACCESS 	0x040 /* Bus Error in Table1 access */
#define   VC_ERR_PT2_ILLEGAL_ACCESS 	0x080 /* Bus Error in Table2 access */
#define   VC_ERR_CACHE_ILLEGAL_ACCESS 	0x100 /* Bus Error during the cache access */
#define   VC_ERR_READ 			0x1000 /* access was a read */
#define VC_I_BAD_VADDR 	13 /* Instruction Bad Virtual Address Register */
#define VC_D_BAD_VADDR 	14 /* Data Bad Virtual Address Register */
#define VC_PARAMS	15 /* cache parameters */
#define VC_PARAMS_NBL(x)	((x) & 0xf)
#define VC_PARAMS_SCI(x)	(((x) >> 4)  & 0xf)
#define VC_PARAMS_WCI(x)	(((x) >> 8)  & 0x7)
#define VC_PARAMS_STI(x)	(((x) >> 11) & 0xf)
#define VC_PARAMS_WTI(x)	(((x) >> 15) & 0x7)
#define VC_PARAMS_SCD(x)	(((x) >> 18) & 0xf)
#define VC_PARAMS_WCD(x)	(((x) >> 22) & 0x7)
#define VC_PARAMS_STD(x)	(((x) >> 25) & 0xf)
#define VC_PARAMS_WTD(x)	(((x) >> 29) & 0x7)
#define VC_RELEASE	16 /* cache parameters */
#define VC_DATA_L	17 /* cache parameters */
#define VC_DATA_H	18 /* cache parameters */
#define VC_ICACHE_INVAL_PA	19 /* icache inval per physical address */
#define VC_DCACHE_INVAL_PA	20 /* dcache inval per physical address */

#endif /* _TSARMIPS_VCACHEREGS_H_ */
