#ifndef VCIMULTINIC_CHAN_H
#define VCIMULTINIC_CHAN_H

// If you want to debug the driver
#define VCIMULTINIC_CHAN_DEBUG 1

/////////////////////////////////////:

#define VMN_REG_SIZE	0x4000		// Total size of a register page in the network controler
#define VMN_CONT_SIZE	0x4000		// Total size of the containers pages in the network controler
#define VMN_CHAN_SIZE	(VMN_REG_SIZE + VMN_CONT_SIZE)		// Total size of a channel in the network controler

// Buffer size
#define VMN_RX_SW_NBUF		4
#define VMN_RX_HW_NBUF		2
#define VMN_TX_SW_NBUF		4
#define VMN_TX_HW_NBUF		2
#define VMN_NB_CONTAINER	2	// Number of containers in the hardware
#define VMN_CONTAINER_SIZE	0x1000	// Size of a container in the hardware (in bytes)

// MUST BE CHANGED !!!
// Clock setting
#define MY_HZ		100

//
// Setter and Getter for registers
//

#define VMN_CHAN_READ_CONF_REG(sc, reg)					\
  bus_space_read_4(sc->sc_iot, sc->sc_ioh, (VMN_CONT_SIZE + (reg) * sizeof(uint32_t)))

#define VMN_CHAN_READ_STATUS_REG(sc, reg)				\
  bus_space_read_4(sc->sc_iot, sc->sc_ioh, (VMN_CONT_SIZE + (reg) * sizeof(uint32_t)))

#define VMN_CHAN_WRITE_REG(sc, reg, val)				\
  bus_space_write_4(sc->sc_iot, sc->sc_ioh, (VMN_CONT_SIZE + (reg) * sizeof(uint32_t)), \
		    (val))

#define VMN_CHAN_READ_RX_DATA(sc, cont, offset)		\
  bus_space_read_4(sc->sc_iot, sc->sc_ioh,		\
		   ((VMN_CONTAINER_SIZE * cont) + (offset)))

#define VMN_CHAN_WRITE_TX_DATA(sc, cont, offset, val)			\
  bus_space_write_4(sc->sc_iot, sc->sc_ioh,				\
		    ((VMN_CONTAINER_SIZE * VMN_NB_CONTAINER)		\
		     + (VMN_CONTAINER_SIZE * cont) + (offset)),		\
		    (val))

//
// Buffer management structures
//
struct rx_buf {
  /* struct mbuf		*m; */
  uint16_t		current_sw_buf;
  uint16_t		current_hw_buf;
  uint32_t		pkt_ptr;
  uint32_t		rptr;
  uint8_t		container[VMN_NB_CONTAINER][VMN_CONTAINER_SIZE];
  /* bus_dmamap_t		m_dmamap; */
};

struct tx_buf {
  uint16_t		current_sw_buf;
  uint16_t		current_hw_buf;
  uint32_t		pkt_ptr;
  uint32_t		wptr;
  uint8_t		container[VMN_NB_CONTAINER][VMN_CONTAINER_SIZE];
  /* bus_dmamap_t		m_dmamap; */
};

#endif /* VCIMULTINIC_CHAN_H */
