#ifndef VCIMULTINIC_HV_H
#define VCIMULTINIC_HV_H

// If you want to debug the driver/
//#define VCIMULTINIC_DEBUG 1

//
// Setter and Getter for HV
//
#define VMN_HV_READ_CONF_REG(sc, reg)					\
  bus_space_read_4(sc->sc_iot, sc->sc_ioh,				\
		   (VMN_CHAN_SIZE * sc->nb_channel) + ((reg) * sizeof(uint32_t)))

#define VMN_HV_READ_STATUS_REG(sc, reg)					\
  bus_space_read_4(sc->sc_iot, sc->sc_ioh,				\
		   (VMN_CHAN_SIZE * sc->nb_channel) + ((reg) * sizeof(uint32_t)))

#define VMN_HV_WRITE_REG(sc, reg, val)					\
  bus_space_write_4(sc->sc_iot, sc->sc_ioh,				\
		    (VMN_CHAN_SIZE * sc->nb_channel) + ((reg) * sizeof(uint32_t)), \
		    (val))

//
// Setter and Getter for CHAN
//
#define VMN_HV_READ_CHAN_CONF_REG(sc, chan, reg)				\
  bus_space_read_4(sc->sc_iot, sc->sc_ioh,				\
		   (VMN_CHAN_SIZE * chan) + ((reg) * sizeof(uint32_t)))

#define VMN_HV_READ_CHAN_STATUS_REG(sc, chan, reg)				\
  bus_space_read_4(sc->sc_iot, sc->sc_ioh,				\
		   (VMN_CHAN_SIZE * chan) + ((reg) * sizeof(uint32_t)))

#define VMN_HV_WRITE_CHAN_REG(sc, chan, reg, val)				\
  bus_space_write_4(sc->sc_iot, sc->sc_ioh,				\
		    (VMN_CHAN_SIZE * chan) + ((reg) * sizeof(uint32_t)), \
		    (val))

#define VMN_HV_READ_CHAN_DATA(sc, chan, offset)				\
  bus_space_read_4(sc->sc_iot, sc->sc_ioh,				\
		   (VMN_CHAN_SIZE * chan) + (VMN_REG_SIZE + (offset)))

#define VMN_HV_WRITE_CHAN_DATA(sc, chan, offset, val)			\
  bus_space_write_4(sc->sc_iot, sc->sc_ioh,				\
		    (VMN_CHAN_SIZE * chan) + (VMN_REG_SIZE + (offset)),	\
		    (val))

#endif /* VCIMULTINIC_HV_H */
