/* $NetBSD: $ */

/*-
  * Copyright (c) 2009 UPMC/LIP6
  * All rights reserved.
  * This software is distributed under the following condiions
  * compliant with the NetBSD foundation policy.
  *
  * Redistribution and use in source and binary forms, with or without
  * modification, are permitted provided that the following conditions
  * are met:
  * 1. Redistributions of source code must retain the above copyright
  *    notice, this list of conditions and the following disclaimer.
  * 2. Redistributions in binary form must reproduce the above copyright
  *    notice, this list of conditions and the following disclaimer in the
  *    documentation and/or other materials provided with the distribution.
  *
  * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
  * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
  * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
  * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
  * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  * POSSIBILITY OF SUCH DAMAGE.
  */

#ifndef _TSARMIPS_AUTOCONF_H_
#define	_TSARMIPS_AUTOCONF_H_
#include <machine/bus.h>
#include <machine/boot_fdt.h>

/*
 * Machine-dependent structures for autoconfiguration
 */

struct cluster_info {
	int cl_x, cl_y;
	int cl_uvm_freelist;
	struct fdt_node cl_node;
};

extern struct cluster_info cluster_info[]; /* filled in machdep.c */
extern int nclusters;

struct cluster_softc {
	device_t cl_dev; /* our device info */
	struct cluster_info *cl_info;
	device_t cl_xicu; /* xicu associated with this cluster */
};

#define TSARDEVS_NREGS 2
struct tsardevs_attach_args {
	bus_space_tag_t	tsd_tag; 
	bus_dma_tag_t	tsd_dmatag;
	const char 	*tsd_devtype;
	struct fdt_node	*tsd_node; /* FDT node and reg */
	struct fdt_reg	tsd_reg[TSARDEVS_NREGS];
	int		tsd_irq; /* interrupt request line */
	struct cluster_softc *tsd_cluster; /* pointer to our parent */
};

void mttycn_attach(void);

void simhelper_end(int);

#endif	/* !_TSARMIPS_AUTOCONF_H_ */
