/* $NetBSD: $ */

/*-
  * Copyright (c) 2009 UPMC/LIP6
  * All rights reserved.
  * This software is distributed under the following condiions
  * compliant with the NetBSD foundation policy.
  *
  * Redistribution and use in source and binary forms, with or without
  * modification, are permitted provided that the following conditions
  * are met:
  * 1. Redistributions of source code must retain the above copyright
  *    notice, this list of conditions and the following disclaimer.
  * 2. Redistributions in binary form must reproduce the above copyright
  *    notice, this list of conditions and the following disclaimer in the
  *    documentation and/or other materials provided with the distribution.
  *
  * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
  * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
  * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
  * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
  * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  * POSSIBILITY OF SUCH DAMAGE.
  */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: mainbus.c,v 1.36 2005/12/11 12:18:39 christos Exp $");

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/device.h>
#include <uvm/uvm_extern.h>

#include <machine/autoconf.h>
#include <machine/bootinfo.h>
#include <machine/pte.h>
#include <machine/locore.h>
#include "locators.h"

static int  mainbus_match(device_t, cfdata_t, void *);
static void mainbus_attach(device_t, device_t, void *);
static int  mainbus_print(void *, const char *);
static int  mainbus_cpu_print(void *, const char *);
static int  mainbus_search(device_t, cfdata_t, const int *, void *);


CFATTACH_DECL_NEW(mainbus, 0,
    mainbus_match, mainbus_attach, NULL, NULL);


static int
mainbus_match(device_t parent, cfdata_t match, void *aux)
{
	return (1);
}

static void
mainbus_attach(device_t parent, device_t self, void *aux)
{
	struct cpu_attach_args cpua;
	int i;
	extern struct btinfo_cpus *bi_cpus; /* XXX */

	printf("\n");

	/* first attach CPUs */
	if (bi_cpus) {
		/*
		 * add a identity mapping for cputramp(), removed
		 * once all CPUs have swicthed to virual mode.
		 *
		 */
		pmap_seccpus_bootstrap_add((vaddr_t)cputramp);
		for (i = 0; i < BOOTINFO_NCPUS_MAX; i++) {
			if (bi_cpus->cpu_bitmaps[i / 32] & (1 << (i % 32))) {
				cpua.cpua_cpuid = i;
				config_found_ia(self, "cpubus", &cpua,
				    mainbus_cpu_print);
			}
		}
		pmap_seccpus_bootstrap_remove((vaddr_t)cputramp);
	} else {
		/* no CPU info, assume only one */
		cpua.cpua_cpuid = -1;
		config_found_ia(self, "cpubus", &cpua, mainbus_cpu_print);
	}

	/* then xicu (which needs CPUs) */
	config_search_ia(mainbus_search, self, "xicubus", NULL);
	/* then attach all devices described in kernel config (needs xicu) */
	config_search_ia(mainbus_search, self, "mainbus", NULL);
}

static int
mainbus_print(aux, pnp)
	void *aux;
	const char *pnp;
{
	struct mainbus_attach_args *ma = aux;

	if (ma->device_size > 0)
		aprint_normal(" addr 0x%" PRIx64 "/%u", ma->device_base,
		    (u_int)ma->device_size);
	if (ma->irq >= 0)
		aprint_normal(" irq %d", ma->irq);
	return (UNCONF);
}

static int
mainbus_cpu_print(aux, pnp)
	void *aux;
	const char *pnp;
{
	struct cpu_attach_args *cpua = aux;

	if (cpua->cpua_cpuid != -1)  
		aprint_normal(" cpuid %d", cpua->cpua_cpuid);
	return (UNCONF);
}

static int
mainbus_search(device_t parent, cfdata_t cf, const int *ldesc, void *aux)
{
	struct mainbus_attach_args ma;

	ma.tag = 0;
	ma.device_base = (u_int)cf->cf_loc[MAINBUSCF_ADDR];
	ma.device_size = cf->cf_loc[MAINBUSCF_SIZE];
	ma.irq = cf->cf_loc[MAINBUSCF_IRQ];

	if (config_match(parent, cf, &ma) > 0)
		config_attach(parent, cf, &ma, mainbus_print);
	return (0);
}
