/*	$NetBSD: uvm.h,v 1.55 2008/06/04 15:06:04 ad Exp $	*/

/*
 *
 * Copyright (c) 1997 Charles D. Cranor and Washington University.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Charles D. Cranor and
 *      Washington University.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * from: Id: uvm.h,v 1.1.2.14 1998/02/02 20:07:19 chuck Exp
 */

#ifndef _UVM_UVM_CPU_H_
#define _UVM_UVM_CPU_H_

#if defined(_KERNEL_OPT)
#include "opt_uvmnuma.h"
#endif
/*
 * pull in VM_NFREELIST
 */
#include <machine/vmparam.h>

#include <uvm/uvm_pglist.h>
/*
 * per-cpu data
 */

struct uvm_cpu {
	struct pgfreelist page_free[VM_NFREELIST]; /* unallocated pages */
#ifdef VM_NUMA
	int page_cpu_freelist;		/* CPU's preferred free list */
#ifdef VM_NUMA_STRAT_ROUNDROBIN
	int page_cpu_next_freelist;	/* CPU's round-robbin list allocation */
#endif
#endif
	int page_free_nextcolor;	/* next color to allocate from */
	int page_idlezero_next;		/* which color to zero next */
	bool page_idle_zero;		/* TRUE if we should try to zero
					   pages in the idle loop */
	int pages[PGFL_NQUEUES];	/* total of pages in page_free */
};

#endif /* _UVM_UVM_CPU_H_ */
