/*	$NetBSD: intr.h,v 1.32 2008/01/04 21:54:05 ad Exp $	*/

/*
 * Copyright (c) 1998 Jonathan Stone.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Jonathan Stone for
 *      the NetBSD Project.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _TSARMIPS_INTR_H_
#define _TSARMIPS_INTR_H_

#include <mips/intr.h>

static __inline int ipl2irq(int);
static __inline int __unused
ipl2irq(int ipl)
{
	switch(ipl) {
	case IPL_HIGH:
		return 0;
	case IPL_DDB:
	case IPL_SCHED:
		return 1;
	case IPL_VM:
		return 2;
	default:
		panic("ipl2irq: bad IPL %d", ipl);
		/* NOTREACHED */
	}
}

#ifdef _KERNEL
#ifndef _LOCORE

#include <mips/cpuregs.h>
#include <mips/locore.h>


/*
 * interrupt handler registration. 
 */

typedef int irq_line_t;

struct intrhand {
	device_t ih_pic_dev;
	irq_line_t ih_irq;
	int (*ih_func)(void *);
	void *ih_arg;
	struct evcnt ih_ev;
};

typedef struct intrhand *irq_t;
typedef enum irq_type {
	IRQ_HWI = 0,
	IRQ_PTI = 1,
	IRQ_WTI = 2
} irq_type_t;

struct boot_fdt_prop;

irq_t intr_establish(const struct boot_fdt_prop *irq, ipl_t,
    const char *, char *, int (*)(void *), void *, struct cpu_info *);

void intr_init(void);

#endif /* !_LOCORE */
#endif /* _KERNEL */

#endif	/* !_TSARMIPS_INTR_H_ */
