/* $NetBSD: $ */

/*-
  * Copyright (c) 2009 UPMC/LIP6
  * All rights reserved.
  * This software is distributed under the following condiions
  * compliant with the NetBSD foundation policy.
  *
  * Redistribution and use in source and binary forms, with or without
  * modification, are permitted provided that the following conditions
  * are met:
  * 1. Redistributions of source code must retain the above copyright
  *    notice, this list of conditions and the following disclaimer.
  * 2. Redistributions in binary form must reproduce the above copyright
  *    notice, this list of conditions and the following disclaimer in the
  *    documentation and/or other materials provided with the distribution.
  *
  * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
  * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
  * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
  * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
  * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  * POSSIBILITY OF SUCH DAMAGE.
  */

/*
 * functions exported by the xicu driver
 */
#include <machine/bus.h>

struct fdt_node;
void xicu_intr(int, vaddr_t, u_int32_t);
irq_t xicu_intr_establish(device_t, irq_type_t, irq_line_t, ipl_t, const char *,
	    char *, int (*handler)(void *), void *, struct cpu_info *);
void xicu_init(struct fdt_node *);
void xicu_wake_cpu(struct cpu_info *, int, uint32_t);
int xicu_send_ipi(struct cpu_info *, int);

struct xicu_wti {
	device_t wti_dev; /* XICU device for this WTI */
	irq_line_t wti_line; /* WTI index in XICU */
	bus_space_tag_t wti_tag; /* for software write */
	bus_space_handle_t wti_handle; 
	paddr_t	wti_paddr; /* for hardware write */
};
bool xicu_wti_alloc(struct cpu_info *, struct xicu_wti *);
void xicu_wti_free(struct xicu_wti *);
