/* $NetBSD: $ */
/*-
  * Copyright (c) 2009 UPMC/LIP6
  * All rights reserved.
  * This software is distributed under the following condiions
  * compliant with the NetBSD foundation policy.
  *
  * Redistribution and use in source and binary forms, with or without
  * modification, are permitted provided that the following conditions
  * are met:
  * 1. Redistributions of source code must retain the above copyright
  *    notice, this list of conditions and the following disclaimer.
  * 2. Redistributions in binary form must reproduce the above copyright
  *    notice, this list of conditions and the following disclaimer in the
  *    documentation and/or other materials provided with the distribution.
  *
  * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
  * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
  * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
  * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
  * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  * POSSIBILITY OF SUCH DAMAGE.
  */

/* definitions for the informations provided by the TSAR boot rom */
/* default address for the TFI - should be passed in a0 by preloader */
#define TFI_ADDRESS	0xbfc00008 
#define TFIO_VERS	0
#define TFIO_DTB	4
#define TFIO_PUTC	8
#define TFIO_GETC	12
#define TFIO_READ	16
#define TFI_VERSION(x)  (((x) >> 16) & 0xffff)
#define TFI_REVISION(x) (((x) >>  0) & 0xffff)

#ifndef _LOCORE
struct tsar_firmware_info {
	uint32_t tfi_version;	/* firmware version/revision */
	void	*tfi_dtb_addr;	/* pointer to the binary device tree */
	void	(*tfi_putc)(const char); /* pointer to putc() function */
	int	(*tfi_getc)(const int *); /* pointer to getc() function */
	int	(*tfi_read)(int, void *, int); /* pointer to block read */
};
const struct tsar_firmware_info *TFI_DATA;
#endif /* _LOCORE */
