/*	$NetBSD: vmparam.h,v 1.14 2001/08/24 15:33:17 mhitch Exp $	*/

#ifndef _TSARMIPS_VMPARAM_H_
#define _TSARMIPS_VMPARAM_H_
#include <machine/param.h> /* for MAXCPU */

/*
 * We use a 4K page on MIPS systems.  Override PAGE_* definitions
 * to compile-time constants.
 */
#define	PAGE_SHIFT	12
#define	PAGE_SIZE	(1 << PAGE_SHIFT)
#define	PAGE_MASK	(PAGE_SIZE - 1)

/*
 * USRSTACK is the top (end) of the user stack.
 * Make it just one page below the kernel
 */
#define	USRSTACK	0xbffff000

/* alignment requirement for u-area space in bytes */
#define	USPACE_ALIGN	USPACE

/*
 * Virtual memory related constants, all in bytes
 */
#ifndef MAXTSIZ
#define	MAXTSIZ		(64*1024*1024)		/* max text size */
#endif
#ifndef DFLDSIZ
#define	DFLDSIZ		(128*1024*1024)		/* initial data size limit */
#endif
#ifndef MAXDSIZ
#define	MAXDSIZ		(512*1024*1024)		/* max data size */
#endif
#ifndef	DFLSSIZ
#define	DFLSSIZ		(2*1024*1024)		/* initial stack size limit */
#endif
#ifndef	MAXSSIZ
#define	MAXSSIZ		(32*1024*1024)		/* max stack size */
#endif

/*
 * PTEs for mapping user space into the kernel for phyio operations.
 * 300 is what's used on i386
 */
#define USRIOSIZE	300

/*
 * PTEs for system V style shared memory.
 * This is basically slop for kmempt which we actually allocate (malloc) from.
 */
#ifndef SHMMAXPGS
#define SHMMAXPGS	1024		/* 4mb */
#endif

/*
 * Mach derived constants
 */

/* user/kernel map constants */
#define VM_MIN_ADDRESS		((vaddr_t)0x00000000UL)
#define VM_MAXUSER_ADDRESS	((vaddr_t)0xc0000000UL)
#define VM_MAX_ADDRESS		((vaddr_t)0xc0000000UL)
#define VM_MIN_KERNEL_ADDRESS	((vaddr_t)0xc0000000UL)
#define VM_MAX_KERNEL_ADDRESS	((vaddr_t)0xf0000000UL)

/*
 * The address to which unspecified mapping requests default
 */
#define __USE_TOPDOWN_VM
#define VM_DEFAULT_ADDRESS(da, sz) \
	trunc_page(USRSTACK - MAXSSIZ - (sz))

/* virtual sizes (bytes) for various kernel submaps */
#define VM_PHYS_SIZE		(USRIOSIZE*PAGE_SIZE)

#define	VM_NFREELIST		MAXCLUSTERS
#define	VM_FREELIST_DEFAULT	0

#define	VM_PHYSSEG_MAX		VM_NFREELIST + 1 /* 64 + 1 free lists */
#define	VM_PHYSSEG_STRAT	VM_PSTRAT_BSEARCH
#define VM_PHYSSEG_NOADD	/* can't add RAM after vm_mem_init */


#include <machine/pmap_pv.h>

#define	__HAVE_VM_PAGE_MD

/*
 * pmap-specific data stored in the vm_page structure.
 */
struct vm_page_md {
        struct pmap_page mp_pp;
};

#define VM_MDPAGE_INIT(pg)						\
	memset(&(pg)->mdpage, 0, sizeof((pg)->mdpage)); \
	PMAP_PAGE_INIT(&(pg)->mdpage.mp_pp)

#endif	/* !_TSARMIPS_VMPARAM_H_ */
