#ifndef VCIMULTINIC_HELPER_H
#define VCIMULTINIC_HELPER_H

#include <sys/mbuf.h>

///////////////////////////////////////////////////////////////////////////////////////////////////
static inline void
vmn_print_hv_reg(struct vcimultinic_softc *sc)
{
  uint32_t reg = 0;

  // Status HV registers
#ifdef VCIMULTINIC_DEBUG
  aprint_normal("vcimultinic: Entering %s\n", __func__);
#endif

  // CONF registers
  aprint_normal("vcimultinic: [%s] VIS : %08x\n", __func__, VMN_HV_READ_CONF_REG(sc, NIC_G_VIS));
  //
  /* aprint_normal("vcimultinic: [%s] GENERAL_CHAN_MAC_ADDR_SET : %08x\n", __func__, VMN_HV_READ_CONF_REG(sc, GENERAL_CHAN_MAC_ADDR_SET)); */
  // We print the MAC ADDR discovered from the controller
  reg = VMN_HV_READ_CONF_REG(sc, NIC_G_MAC_4);
  aprint_normal("vcimultinic: [%s] MAC addr is : ", __func__);
  aprint_normal("%02x:", (reg & 0xFF000000) >> 24);
  aprint_normal("%02x:", (reg & 0x00FF0000) >> 16);
  aprint_normal("%02x:", (reg & 0x0000FF00) >> 8);
  aprint_normal("%02x:", (reg & 0x000000FF));
  reg = VMN_HV_READ_CONF_REG(sc, NIC_G_MAC_2);
  aprint_normal("%02x:", (reg & 0x0000FF00) >> 8);
  aprint_normal("%02x\n", (reg & 0x000000FF));
  //
  aprint_normal("vcimultinic: [%s] NIC_ON : %08u\n", __func__, VMN_HV_READ_CONF_REG(sc, NIC_G_ON));
  //
  aprint_normal("vcimultinic: [%s] BC_EN : %08u\n", __func__, VMN_HV_READ_CONF_REG(sc, NIC_G_BC_ENABLE));
  //
  aprint_normal("vcimultinic: [%s] TDM_EN : %08u\n", __func__, VMN_HV_READ_CONF_REG(sc, NIC_G_TDM_ENABLE));
  //
  /* for (uint8_t i = 0; i < 4; i++) // MAX VALUE MUST BE CHANGED */
  /*   { */
  /* reg = bus_space_read_4(sc->sc_iot, sc->sc_ioh, tdm_timers); */
  /* reg = VMN_HV_READ_CONF_REG(sc, TDM_TIMERS); */
  aprint_normal("vcimultinic: [%s] TDM_TIMERS : %u\n", __func__, VMN_HV_READ_CONF_REG(sc, NIC_G_TDM_PERIOD));
  /* } */

  // STATUS registers

  // TODO
}

///////////////////////////////////////////////////////////////////////////////////////////////////

static inline void
vmn_hv_nic_on(struct vcimultinic_softc *sc)
{
#ifdef VCIMULTINIC_DEBUG
  /* aprint_normal("vcimultinic: Entering %s\n", __func__); */
#endif

  VMN_HV_WRITE_REG(sc, NIC_G_ON, 0x00000001);

  return;
}

///////////////////////////////////////////////////////////////////////////////////////////////////

static inline void
vmn_hv_bc_on(struct vcimultinic_softc *sc)
{
#ifdef VCIMULTINIC_DEBUG
  /* aprint_normal("vcimultinic: Entering %s\n", __func__); */
#endif

  VMN_HV_WRITE_REG(sc, NIC_G_BC_ENABLE, 0x00000001);

  return;
}

///////////////////////////////////////////////////////////////////////////////////////////////////

// sc    =
// chan  = channel number to set the timer to
// timer = value of the timer to set
static inline void
vmn_hv_tdm_on_and_set_timer(struct vcimultinic_softc	*sc,
			    /* uint32_t			chan, */
			    uint32_t			timer)
{
#ifdef VCIMULTINIC_DEBUG
  /* aprint_normal("vcimultinic: Entering %s\n", __func__); */
#endif

  VMN_HV_WRITE_REG(sc, NIC_G_TDM_ENABLE, 0x00000001);
  VMN_HV_WRITE_REG(sc, NIC_G_TDM_PERIOD, timer);

  return;
}

///////////////////////////////////////////////////////////////////////////////////////////////////

// sc    =
// chan  = channel number to set the timer to
// timer = value of the timer to set
static inline void
vmn_hv_set_vis(struct vcimultinic_softc	*sc,
	       uint32_t				vis)
{
#ifdef VCIMULTINIC_DEBUG
  /* aprint_normal("vcimultinic: Entering %s\n", __func__); */
#endif

  VMN_HV_WRITE_REG(sc, NIC_G_VIS, vis);

  return;
}

///////////////////////////////////////////////////////////////////////////////////////////////////

/* // sc    = */
/* // chan  = channel number to set the timer to */
/* // timer = value of the timer to set */
/* static inline void */
/* vmn_hv_set_mac_addr_set(struct vcimultinic_softc	*sc, */
/* 			uint32_t			mac_addr_set) */
/* { */
/* #ifdef VCIMULTINIC_DEBUG */
/*   aprint_normal("vcimultinic: Entering %s\n", __func__); */
/* #endif */

/*   VMN_HV_WRITE_REG(sc, NIC_???, mac_addr_set); */

/*   return; */
/* } */

///////////////////////////////////////////////////////////////////////////////////////////////////

#endif /* VCIMULTINIC_HELPER_H */
