/*	$NetBSD: bootinfo.c,v 1.4 2008/04/28 20:23:34 martin Exp $	*/

/*-
 * Copyright (c) 1999 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Jonathan Stone, Michael Hitch and Simon Burge.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <machine/types.h>
#include <lib/libsa/stand.h>
#include <lib/libkern/libkern.h>

#include <arch/tsarmips/stand/common/bootinfo.h>

struct btinfo_common *bootinfo;		/* bootinfo address */

static char *bi_next;			/* pointer to next bootinfo data */
static int bi_size;			/* current bootinfo size */

void
bi_init(void *bi_addr)
{
	struct btinfo_magic bi_magic;

	bootinfo = bi_addr;
	bootinfo->next = 0;
	bootinfo->type = BTINFO_NONE;

	bi_next = (void *)bootinfo;
	bi_size = 0;

	bi_magic.magic = BOOTINFO_MAGIC;
	bi_add(&bi_magic, BTINFO_MAGIC, sizeof(bi_magic));
}

void
bi_add(void *new, int type, size_t size)
{
	struct btinfo_common *bi;

	if (bi_size + size > BOOTINFO_SIZE)
		return;		/* XXX should report error? */

	bi_size += size;

	/* register new bootinfo data */
	memcpy(bi_next, new, size);
	bi = (void *)bi_next;
	bi->next = size;
	bi->type = type;

	/* update pointer to next bootinfo data */
	bi_next += size;
	bi = (void *)bi_next;
	bi->next = 0;
	bi->type = BTINFO_NONE;
}

int
fdt_fill_cons(const struct fdt_node *node, const struct boot_fdt_prop *prop,
    void *v)
{
	struct btinfo_cons *bi_consp = v;
	struct fdt_reg reg;
	int err;

	if (strcmp((const char *)&prop->prop_value[0], "soclib:tty") != 0 &&
	    strcmp((const char *)&prop->prop_value[0], "vci:tty") != 0)
		return 0;

	err = fdt_read_node_reg(node, &reg, 1);
	if (err) {
		printf("can't read regs for node %s: %d\n",
		    (const char *)&prop->prop_value[0], err);
		bi_consp->cons_physaddr = 0;
		return 0;
	}

	bi_consp->cons_physaddr = reg.reg_addr;
	bi_consp->cons_size = reg.reg_size;
	return 0;
}

