/* $NetBSD: $ */

/*-
  * Copyright (c) 2009 UPMC/LIP6
  * All rights reserved.
  * This software is distributed under the following condiions
  * compliant with the NetBSD foundation policy.
  *
  * Redistribution and use in source and binary forms, with or without
  * modification, are permitted provided that the following conditions
  * are met:
  * 1. Redistributions of source code must retain the above copyright
  *    notice, this list of conditions and the following disclaimer.
  * 2. Redistributions in binary form must reproduce the above copyright
  *    notice, this list of conditions and the following disclaimer in the
  *    documentation and/or other materials provided with the distribution.
  *
  * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
  * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
  * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
  * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
  * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  * POSSIBILITY OF SUCH DAMAGE.
  */

#ifndef _TSARMIPS_PARAM_H_
#define _TSARMIPS_PARAM_H_

#define MAXCPUS         256
#define MAXCLUSTERS	(MAXCPUS / 4)

#include <mips/mips_param.h>

#define mips_round_ppage(x)      ((((paddr_t)(x)) + NBPG - 1) & ~(NBPG-1))
#define mips_trunc_ppage(x)      ((paddr_t)(x) & ~(NBPG-1))

/*
 * Machine dependent constants for soclib/tsarmips systems
 */

#undef _MACHINE
#define	_MACHINE	tsarmips
#undef MACHINE
#define	MACHINE		"tsarmips"

#ifndef KERNBASE
#define KERNBASE	0xc0000000	/* start of kernel virtual space */
#endif

#define	DEV_BSIZE	512
#define	DEV_BSHIFT	9		/* log2(DEV_BSIZE) */
#define BLKDEV_IOSIZE	2048
#define	MAXPHYS		(64 * 1024)	/* max raw I/O transfer size */

#ifndef NMBCLUSTERS
#if defined(_KERNEL_OPT)
#include "opt_gateway.h"
#endif

#ifdef GATEWAY
#define	NMBCLUSTERS	2048		/* map size, max cluster allocation */
#else
#define	NMBCLUSTERS	1024		/* map size, max cluster allocation */
#endif
#endif

#ifdef _KERNEL
#ifndef _LOCORE

extern int div_delay;

static __inline void __attribute__((__unused__))
delay(int n)
{
	register int __N = div_delay * n;
	do {
		__asm("addiu %0,%1,-1" : "=r" (__N) : "0" (__N));
	} while (__N > 0);
}
static __inline void __attribute__((__unused__))
DELAY(int n)
{
	delay(n);
}

#include <machine/intr.h>

#endif	/* !_LOCORE */
#endif	/* _KERNEL */

#endif	/* !_TSARMIPS_PARAM_H_ */
