/* $NetBSD: $ */
/*-
  * Copyright (c) 2009 UPMC/LIP6
  * All rights reserved.
  * This software is distributed under the following condiions
  * compliant with the NetBSD foundation policy.
  *
  * Redistribution and use in source and binary forms, with or without
  * modification, are permitted provided that the following conditions
  * are met:
  * 1. Redistributions of source code must retain the above copyright
  *    notice, this list of conditions and the following disclaimer.
  * 2. Redistributions in binary form must reproduce the above copyright
  *    notice, this list of conditions and the following disclaimer in the
  *    documentation and/or other materials provided with the distribution.
  *
  * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
  * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
  * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
  * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
  * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  * POSSIBILITY OF SUCH DAMAGE.
  */

/* driver to access the block device via the TSAR prom callbaks */

#include <lib/libsa/stand.h>
#include <lib/libkern/libkern.h>
#include <machine/tsar_firmware.h>

#include <sys/param.h>
#include <sys/disklabel.h>

#include <lib/libsa/stand.h>
#include <lib/libsa/ufs.h>
#include <lib/libsa/ustarfs.h>
#include <lib/libsa/cd9660.h>
#include <lib/libsa/lfs.h>

int     blkdevopen (struct open_file *, ...);

int     blkdevstrategy (void *, int, daddr_t, size_t, void *, size_t *);
#if !defined(LIBSA_NO_FS_CLOSE)
int     blkdevclose (struct open_file *);
#endif /* defined(LIBSA_NO_FS_CLOSE) */


#ifndef LIBSA_SINGLE_FILESYSTEM
#ifdef LIBSA_NO_FS_CLOSE
#define ufs_close       0
#define lfsv1_close     0
#define lfsv2_close     0
#define cd9660_close    0
#define ustarfs_close   0
#define nfs_close       0
#endif
#ifdef LIBSA_NO_FS_WRITE
#define ufs_write       0
#define lfsv1_write     0
#define lfsv2_write     0
#define cd9660_write    0
#define ustarfs_write   0
#define nfs_write       0
#endif
struct fs_ops file_system[] = {
        FS_OPS(ufs),
        FS_OPS(lfsv1),
        FS_OPS(lfsv2),
        FS_OPS(cd9660),
        FS_OPS(ustarfs),
#ifdef BOOTNET
        FS_OPS(nfs),
#endif
};

int nfsys = sizeof(file_system)/sizeof(struct fs_ops);
#endif

int
blkdevstrategy(void *devdata, int flag, daddr_t dblk, size_t size, void *buf, size_t *rsize)
{
	if (flag != F_READ)
		return EROFS;


	if (size & (TSARMIPS_BOOT_BLOCK_BLOCKSIZE - 1))
		return EINVAL;

	if (rsize)
		*rsize = size;

	if (size != 0 && TFI_DATA->tfi_read(dblk, buf,
	    size / TSARMIPS_BOOT_BLOCK_BLOCKSIZE) != 0)
		return EIO;

	return 0;
}

int
blkdevopen(struct open_file *f, ...)
{
	f->f_devdata = NULL;

#if 0
	if (part != RAW_PART)
		return (ENXIO);
#endif
	return 0;
}

#if !defined(LIBSA_NO_FS_CLOSE)
int
blkdevclose(struct open_file *f)
{
	return 0;
}
#endif

int
devopen(struct open_file *f, const char *fname, char **file)
{
	int rc;
	rc =  DEV_OPEN(dp)(f);
	if (rc)
		return rc;
	if (file)
		*file = (char *)fname;
	return 0;
}
