/*	$NetBSD: cpu.h,v 1.27 2001/09/04 06:23:17 simonb Exp $	*/

#ifndef TSARMIPS_CPU_H
#define TSARMIPS_CPU_H
#ifdef _KERNEL
#ifndef _LOCORE
#include <sys/device.h>
#include <sys/queue.h>

struct md_cpu_info {
	struct cpu_info *ci_next; /* CPU list */
	device_t ci_xicu; /* pointer to our interrupt controller */
	int ci_xicuidx; /* our index in the interrupt controller */
	struct pmap *ci_pmap; /* pmap active on this CPU */
	LIST_HEAD(, pmap) ci_freepmaps; /* deffered pmap free */
	int ci_l1_itw; /* instruction TLB number of ways */
	int ci_l1_its; /* instruction TLB number of sets */
	int ci_l1_icw; /* L1 instruction cache number of ways */
	int ci_l1_ics; /* L1 instruction cache number of sets */
	int ci_l1_dtw; /* data TLB number of ways */
	int ci_l1_dts; /* data TLB number of sets */
	int ci_l1_dcw; /* L1 data cache number of ways */
	int ci_l1_dcs; /* L1 data cache number of sets */
	int ci_l1_cls; /* L1 instruction/data cache line size */
};

#endif /* !_LOCORE*/
#endif /* _KERNEL */
#define ci_pmap ci_mdcpu.ci_pmap
#define ci_mappm ci_mdcpu.ci_mappm
#define ci_freepmaps ci_mdcpu.ci_freepmaps
#define ci_xicu ci_mdcpu.ci_xicu
#define ci_xicuidx ci_mdcpu.ci_xicuidx
#define ci_l1_itw ci_mdcpu.ci_l1_itw
#define ci_l1_its ci_mdcpu.ci_l1_its
#define ci_l1_icw ci_mdcpu.ci_l1_icw
#define ci_l1_ics ci_mdcpu.ci_l1_ics
#define ci_l1_dtw ci_mdcpu.ci_l1_dtw
#define ci_l1_dts ci_mdcpu.ci_l1_dts
#define ci_l1_dcw ci_mdcpu.ci_l1_dcw
#define ci_l1_dcs ci_mdcpu.ci_l1_dcs
#define ci_l1_cls ci_mdcpu.ci_l1_cls
#define __HAS_MD_CPUINFO
#include <mips/cpu.h>

#endif /* TSARMIPS_CPU_H */
