#include <lib/libsa/stand.h>
#include <lib/libsa/loadfile.h>
#include <lib/libkern/libkern.h>
#include <machine/boot_fdt.h>
#include "vers.h"
#include "tty.h"
#include "bootinfo.h"

void main(void);

void doboot(char *);
void dohelp(char *);
void find_cpus(struct btinfo_cpus *bi);

static uint8_t bootinfo[BOOTINFO_SIZE];
struct btinfo_symtab bi_syms;
struct btinfo_cpus bi_cpus;
struct btinfo_fdt bi_fdt;

uint32_t cpu_vectors[BOOTINFO_NCPUS_MAX];
uint32_t cpu_bitmaps[BOOTINFO_NCPUS_MAX / 32];

void
find_cpus(struct btinfo_cpus *bi)
{
	int i;
	for (i = 0; i < BOOTINFO_NCPUS_MAX; i++) {
		if (cpu_bitmaps[i / 32] & (1 << (i % 32))) {
			if (cpu_vectors[i] == 0) {
				printf("cpu %d present\n", i);
			} else {
				printf("cpu %d not ready\n", i);
				cpu_bitmaps[i / 32] &= ~(1 << (i % 32));
			}
		}
	}
	memcpy(&bi->cpu_bitmaps, cpu_bitmaps, sizeof(cpu_bitmaps));
	bi->cpu_vectors = (int32_t)cpu_vectors;
}

void
main()
{
#if 0
	static char input[80];
	char *c;
#endif
	struct boot_fdt_header *fdt = (void *)0xbfd00000;
	void (*entry)(void *);
	u_long marks[MARK_MAX];

	putchar('\n');
	printf("%s " NETBSD_VERS " Bootstrap, Revision %s\n",
	    bootprog_name, bootprog_rev);
	printf("(%s, %s)\n", bootprog_maker, bootprog_date);
	memset(marks, 0, sizeof marks);
	bi_init(bootinfo);
#if 0
	for(;;) {
		c = input;
		input[0] = '\0';
		printf("> ");
		gets(input);
		printf("got %s\n", input);
		while(*c == ' ') c++;
		if(*c) {
			if (strcmp(input, "help") == 0)
				dohelp(NULL);
			if (strcmp(input, "help") == 0)
				dohelp(NULL);
			if (strcmp(input, "boot") == 0) {
				if (loadfile("netbsd", marks, LOAD_KERNEL) < 0)
					printf("boot: %s\n", strerror(errno));
				else
					printf("boot returned\n");
			}
		}
	}
#else
				marks[MARK_START] = 0;
				if (loadfile("netbsd", marks, LOAD_KERNEL) < 0)
					printf("boot: %s\n", strerror(errno));
				else {
					bi_syms.nsym = marks[MARK_NSYM];
					bi_syms.ssym = marks[MARK_SYM];
					bi_syms.esym = marks[MARK_END];
					bi_add(&bi_syms, BTINFO_SYMTAB, sizeof(bi_syms));
					entry = (void *)marks[MARK_ENTRY];
					printf("Starting at %p, "
					    "syms %d/0x%x/0x%x at %p\n\n",
					    entry,
					    bi_syms.nsym, bi_syms.ssym,
					    bi_syms.esym, bootinfo);

					/* consider all CPUs got time to start*/
					find_cpus(&bi_cpus);
					bi_add(&bi_cpus, BTINFO_CPUS,
					    sizeof(bi_cpus));
					if (fdt->fdt_magic !=
					    htobe32(FDT_MAGIC)) {
						printf("bad fdt header 0x%x "
						    "at %p\n",
						    be32toh(fdt->fdt_magic),
						    fdt);
					} else {
						bi_fdt.fdt_physaddr =
						    (uint32_t)fdt;
						bi_fdt.fdt_size = be32toh(
						    fdt->fdt_totalsize);
						bi_add(&bi_fdt, BTINFO_FDT,
						    sizeof(bi_fdt));
					}
					(*entry)(bootinfo);
					printf("kernel returned\n");
				}
#endif
	return;
}

void
dohelp(char *unused)
{
	printf("nothing for now\n");
}

void
putchar(int c)
{
	volatile uint32_t *tty = (uint32_t *)(intptr_t)TTY_BASE;
	tty[TTY_WRITE] = c;
}

int
getchar(void)
{
	int c;
	volatile uint32_t *tty = (uint32_t *)(intptr_t)TTY_BASE;

	for(;;) {
		if ((uint8_t)tty[TTY_STATUS] != 0) {
			c = tty[TTY_READ] & 0xff;
			if (c != '\r')
				return c;
		}
	}
}
