/*	$NetBSD: intr.h,v 1.32 2008/01/04 21:54:05 ad Exp $	*/

/*
 * Copyright (c) 1998 Jonathan Stone.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Jonathan Stone for
 *      the NetBSD Project.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _TSARMIPS_INTR_H_
#define _TSARMIPS_INTR_H_

#include <sys/evcnt.h>
#include <sys/queue.h>

#define	IPL_NONE	0	/* disable only this interrupt */
#define	IPL_SOFTCLOCK	1	/* clock software interrupts (SI 0) */
#define	IPL_SOFTBIO	1	/* generic software interrupts (SI 0) */
#define	IPL_SOFTNET	2	/* network software interrupts (SI 1) */
#define	IPL_SOFTSERIAL	2	/* serial software interrupts (SI 1) */
#define	IPL_VM		3
#define	IPL_SCHED	4
#define	IPL_HIGH	5

#define	_IPL_N		6

/* map IPL to IRQ, from high to low: IPL_HIGH -> 0, IPL_SOFTCLOCK -> 4 */
#define IPL2IRQ(ipl) (IPL_HIGH - (ipl))

#ifdef _KERNEL
#ifndef _LOCORE

#include <mips/cpuregs.h>
#include <mips/locore.h>

#define spl0()		(void)_spllower(0)
#define splx(s)		(void)_splset(s)
#define splvm()		splraiseipl(makeiplcookie(IPL_VM))
#define splsched()	splraiseipl(makeiplcookie(IPL_SCHED))
#define splhigh()	splraiseipl(makeiplcookie(IPL_HIGH))

#define splsoftclock()	splraiseipl(makeiplcookie(IPL_SOFTCLOCK))
#define splsoftbio()	splraiseipl(makeiplcookie(IPL_SOFTBIO))
#define splsoftnet()	splraiseipl(makeiplcookie(IPL_SOFTNET))
#define splsoftserial()	splraiseipl(makeiplcookie(IPL_SOFTSERIAL))

typedef int ipl_t;
typedef struct {
	int _spl;
} ipl_cookie_t;

/*
 * interrupt handler registration. 
 */

struct xicu_intrhand;
typedef struct xicu_intrhand *irq_t;
typedef enum irq_type {
	IRQ_HWI = 0,
	IRQ_PTI = 1,
	IRQ_WTI = 2
} irq_type_t;

irq_t intr_establish(irq_type_t, int, int,
    const char *, int (*)(void *), void *);

extern const uint32_t ipl2spl[];

static inline ipl_cookie_t
makeiplcookie(ipl_t ipl)
{
	return (ipl_cookie_t){._spl = ipl2spl[ipl]};
}

static inline int
splraiseipl(ipl_cookie_t icookie)
{

	return _splraise(icookie._spl);
}


#include <mips/softintr.h>

void intr_init(void);
#endif /* !_LOCORE */
#endif /* _KERNEL */

#endif	/* !_TSARMIPS_INTR_H_ */
