/* $NetBSD: $ */

/*-
  * Copyright (c) 2010 UPMC/LIP6
  * All rights reserved.
  * This software is distributed under the following condiions
  * compliant with the NetBSD foundation policy.
  *
  * Redistribution and use in source and binary forms, with or without
  * modification, are permitted provided that the following conditions
  * are met:
  * 1. Redistributions of source code must retain the above copyright
  *    notice, this list of conditions and the following disclaimer.
  * 2. Redistributions in binary form must reproduce the above copyright
  *    notice, this list of conditions and the following disclaimer in the
  *    documentation and/or other materials provided with the distribution.
  *
  * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
  * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
  * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
  * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
  * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  * POSSIBILITY OF SUCH DAMAGE.
  */

/* driver for soclib's multitty device */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: machdep.c,v 1.223 2008/07/02 17:28:56 ad Exp $");

#include <sys/param.h>
#include <sys/ioctl.h>
#include <sys/proc.h>
#include <sys/systm.h>
#include <sys/device.h>
#include <sys/conf.h>
#include <sys/kauth.h>

#include <machine/autoconf.h>
#include <machine/bus.h>

static int simhelper_match(device_t, cfdata_t, void *);
static void simhelper_attach(device_t, device_t, void *);

struct simhelper_softc {
	device_t sc_dev;
	bus_space_tag_t sc_tag;
	bus_space_handle_t sc_handle;
};

/* simhelper devices definition: only 4 32bits registers */
#define SIMHELPER_SC_STOP		0x0
#define SIMHELPER_END_WITH_RETVAL	0x4
#define SIMHELPER_EXCEPT_WITH_VAL	0x8
#define SIMHELPER_PAUSE_SIM 		0xc

struct simhelper_softc *simhelper_softc = NULL;

CFATTACH_DECL_NEW(simhelper, sizeof(struct simhelper_softc),
    simhelper_match, simhelper_attach, NULL, NULL);

int
simhelper_match(device_t parent, cfdata_t match, void *aux)
{
	struct tsardevs_attach_args *tsd = aux;
	if (simhelper_softc != NULL)
		return 0; /* can have only one simhelper */
	if (strcmp(tsd->tsd_devtype, "soclib:simhelper") != 0)
		return 0;
	return 1;
}

void
simhelper_attach(device_t parent, device_t self, void *aux)
{
	struct simhelper_softc *sc = device_private(self);
	struct tsardevs_attach_args *tsd = aux;

	aprint_normal(": Simulation Helper driver\n");

	sc->sc_dev = self;
	sc->sc_tag = tsd->tsd_tag;

	/* map the device */
	if (bus_space_map(sc->sc_tag,
	    tsd->tsd_reg.reg_addr,tsd->tsd_reg.reg_size, 0, &sc->sc_handle)) {
			aprint_error_dev(self, "couldn't map registers\n");
			return;
	}
	simhelper_softc = sc;
}

void
simhelper_end(int ex)
{
	aprint_normal_dev(simhelper_softc->sc_dev,
	    ": platoform exit %d\n", ex);
	bus_space_write_4(simhelper_softc->sc_tag,
	    simhelper_softc->sc_handle, SIMHELPER_END_WITH_RETVAL, ex);
}
