
#include  "Lofig.h"
#include  "Locon.h"
#include  "Library.h"


Library* Library::_singleton = NULL;


void  Library::destroy ()
{
  if ( _singleton ) delete _singleton;
  _singleton = NULL;
}


Lofig* Library::getModel ( unsigned int modelType )
{
  if ( _singleton == NULL ) _singleton = new Library ();
  return _singleton->_getModel(modelType);
}


void  Library::_createAnd2 ()
{
  _table[And2] = new Lofig ( "and2" );

  _table[And2]->addSignal ( "i0"  , Locon::External );
  _table[And2]->addSignal ( "i1"  , Locon::External );
  _table[And2]->addSignal ( "q"   , Locon::External );

  _table[And2]->addConnector ( "i0" , Locon::In , _table[And2]->findSignal("i0" ) );
  _table[And2]->addConnector ( "i1" , Locon::In , _table[And2]->findSignal("i1" ) );
  _table[And2]->addConnector ( "q"  , Locon::Out, _table[And2]->findSignal("q"  ) );

  _table[And2]->setMode ( Lofig::Abstract );
}


void  Library::_createOr2 ()
{
  _table[Or2] = new Lofig ( "or2" );

  _table[Or2]->addSignal ( "i0"  , Locon::External );
  _table[Or2]->addSignal ( "i1"  , Locon::External );
  _table[Or2]->addSignal ( "q"   , Locon::External );

  _table[Or2]->addConnector ( "i0" , Locon::In , _table[Or2]->findSignal("i0" ) );
  _table[Or2]->addConnector ( "i1" , Locon::In , _table[Or2]->findSignal("i1" ) );
  _table[Or2]->addConnector ( "q"  , Locon::Out, _table[Or2]->findSignal("q"  ) );

  _table[Or2]->setMode ( Lofig::Abstract );
}


void  Library::_createXor2 ()
{
  _table[Xor2] = new Lofig ( "xor2" );

  _table[Xor2]->addSignal ( "i0"  , Locon::External );
  _table[Xor2]->addSignal ( "i1"  , Locon::External );
  _table[Xor2]->addSignal ( "q"   , Locon::External );

  _table[Xor2]->addConnector ( "i0" , Locon::In , _table[Xor2]->findSignal("i0" ) );
  _table[Xor2]->addConnector ( "i1" , Locon::In , _table[Xor2]->findSignal("i1" ) );
  _table[Xor2]->addConnector ( "q"  , Locon::Out, _table[Xor2]->findSignal("q"  ) );

  _table[Xor2]->setMode ( Lofig::Abstract );
}


Library::Library ()
{
  _createAnd2 ();
  _createOr2  ();
  _createXor2 ();
}


Lofig* Library::_getModel ( unsigned int modelType )
{
  if ( modelType < ModelTypeSize ) return _table[modelType];
  
  std::cerr << "[ERROR] Library::getModel(): No model of type id:" << modelType << "." << std::endl;
  return NULL;
}
