
#ifndef  __SCHEDULER_H__
#define  __SCHEDULER_H__

#include  <string>
#include  <map>
#include  <vector>
#include  <CaoTypes.h>

class BoolNet;
class Event;


// Date is used as key by the scheduler's map<>.
class Date {
  private:
    unsigned int  _time;
    unsigned int  _delta;
  public:
    inline               Date      ( unsigned int time, unsigned int delta );
    inline unsigned int  getTime   () const;
    inline unsigned int  getDelta  () const;
    friend bool          operator< ( const Date& lhs, const Date& rhs );
};


class Scheduler {
  private:
    BoolNet*                              _network;
    std::map<Date, std::vector<Event*> >  _events;
  public:
           Scheduler  ( BoolNet* );
    Event* addEvent   ( const std::string& variable, ValueType, unsigned int time, unsigned int delta=0 );
    Event* addEvent   ( Signal*, ValueType, unsigned int time, unsigned int delta=0 );
    void   simulate   ();
    void   toPatterns ( std::ostream& );
    void   toPatterns ();
  private:
    void   _reset     ();
    void   _header    ();
    void   _display   ( const Date& );
};


// Class Date inline functions.
inline Date::Date ( unsigned int time, unsigned int delta )
  : _time (time)
  , _delta(delta)
{ }


inline unsigned int  Date::getTime  () const{ return _time; }
inline unsigned int  Date::getDelta () const{ return _delta; }


inline bool  operator< ( const Date& lhs, const Date& rhs )
{
  if ( lhs._time != rhs._time ) return (lhs._time < rhs._time);
  return (lhs._delta < rhs._delta);
}


#endif  // __SCHEDULER_H__
