
#ifndef __BOOLNET_H__
#define __BOOLNET_H__

#include  <iostream>
#include  <string>
#include  <vector>
#include  "CaoTypes.h"

class Signal;
class Process;


class BoolNet {
  private:
    std::string            _name;
    std::vector<Signal*>   _signals;
    std::vector<Process*>  _processes;
  public:
                                  BoolNet      ( const std::string& );
    inline std::string&           getName      ();
           Signal*                getSignal    ( const std::string& );
    inline std::vector<Signal*>&  getSignals   ();
    inline std::vector<Process*>& getProcesses ();
           Signal*                addSignal    ( const std::string&, SignalType );
           Process*               addProcess   ( const std::string&, const std::string&, unsigned int delay );
           void                   toDot        ( std::ostream& );
           void                   toDot        ();
};


inline std::string&           BoolNet::getName      () { return _name; }
inline std::vector<Signal*>&  BoolNet::getSignals   () { return _signals; }
inline std::vector<Process*>& BoolNet::getProcesses () { return _processes; }


#endif  // __BOOLNET_H__
