
#ifndef  __SIGNAL_H__
#define  __SIGNAL_H__

#include  <string>
#include  <set>
#include  "EbmVar.h"

class Process;
class BoolNet;


class Signal {
  private:
    BoolNet*            _network;
    EbmVar*             _variable;
    SignalType          _type;
    std::set<Process*>  _processes;
  public:
                               Signal       ( BoolNet*, const std::string&, SignalType );
    inline std::string         getName      ();
    inline SignalType          getType      ();
    inline ValueType           getValue     ();
    inline std::set<Process*>& getProcesses ();
    inline void                addProcess   ( Process* );
    inline void                setValue     ( ValueType );
};


inline std::string         Signal::getName      () { return _variable->getName(); }
inline SignalType          Signal::getType      () { return _type; }
inline ValueType           Signal::getValue     () { return _variable->getValue(); }
inline std::set<Process*>& Signal::getProcesses () { return _processes; }
inline void                Signal::addProcess   ( Process* process ) { _processes.insert(process); }
inline void                Signal::setValue     ( ValueType value ) { _variable->setValue(value); }


#endif  // __SIGNAL_H__
