
#ifndef  __EVENT_H__
#define  __EVENT_H__

#include  "Signal.h"
#include  "Scheduler.h"


class Event {
  private:
    Signal*    _signal;
    ValueType  _value;
    Date       _date;
  public:
    inline             Event             ( Signal*, ValueType, Date& );
    inline  Signal*    getSignal         ();
    inline  ValueType  getValue          ();
    inline  Date&      getDate           ();
    inline  void       updateSignalValue ();
};


// Event inline functions.
inline  Event::Event ( Signal* signal, ValueType value, Date& date )
  : _signal(signal)
  , _value (value)
  , _date  (date)
{ }

inline  Signal*    Event::getSignal         () { return _signal; }
inline  ValueType  Event::getValue          () { return _value; }
inline  Date&      Event::getDate           () { return _date; }
inline  void       Event::updateSignalValue () { _signal->setValue(_value); }


#endif  // __EVENT_H__

