
#ifndef  __EBMVAR_H__
#define  __EBMVAR_H__

#include  <string> 
#include  <map> 
#include  "CaoTypes.h"
#include  "Ebm.h"


class EbmVar: public Ebm {
  private:
    static unsigned int                    _maxIndex;
    static std::map<std::string ,EbmVar*>  _byName;   // All variables storage.
    static std::map<unsigned int,EbmVar*>  _byIndex;
  private :    
             std::string   _name;       // Variable name.
             ValueType     _value;      // Logical value.
             unsigned int  _index;      // Unique index (for ROBDD)
  private:
                           EbmVar   ( std::string name, ValueType value = Low );
    virtual               ~EbmVar   ();
  public:
    static   EbmVar*       create   ( std::string name, ValueType value = Low );
  public:
    virtual  Ebm::Type     getType  ();
    inline   std::string   getName  ();
    inline   ValueType     getValue ();
    inline   unsigned int  getIndex ();
    inline   void          setValue ( ValueType value );
  // Operations sur le dictionnaire
    static   EbmVar*       get      ( unsigned int index );
    static   EbmVar*       get      ( std::string name );
};


inline   std::string   EbmVar::getName  () { return _name; }
inline   ValueType     EbmVar::getValue () { return _value; }
inline   unsigned int  EbmVar::getIndex () { return _index; }
inline   void          EbmVar::setValue ( ValueType value ) { _value=value; }


#endif   // __EBMVAR_H__
