
#include  <iostream>
#include  <fstream>
#include  "BoolNet.h"
#include  "Scheduler.h"

using namespace std;


int main ( int argc, char* argv[] )
{
  BoolNet  andOr ( "AndOr" );

  andOr.addSignal ( "x", In );
  andOr.addSignal ( "y", In );
  andOr.addSignal ( "z", Internal );
  andOr.addSignal ( "t", Out );

  andOr.addProcess ( "z", "x+y", 0 );
  andOr.addProcess ( "t", "x.z", 0 );
  andOr.toDot ();

  Scheduler sched ( &andOr );
  sched.addEvent ( "x",  Low,  0 );
  sched.addEvent ( "y",  Low,  0 );
  sched.addEvent ( "y", High,  5 );
  sched.addEvent ( "y",  Low, 10 );
  sched.addEvent ( "y", High, 15 );
  sched.addEvent ( "x", High,  7 );

  sched.simulate  ();
  sched.toPattern ();

  return 0;
}
