
#ifndef  __EBM_H__
#define  __EBM_H__

#include  <iostream> 
#include  <set> 
#include  <vector> 
#include  "CaoTypes.h" 

class EbmVar;

class Ebm {
  public:
    enum Type { Variable=1, Expression=2 };
  public:
             Ebm ();
    virtual ~Ebm ();
  public:
    virtual Type               getType   () = 0;                            // Implementation is defined in the derived classes
    static  Ebm*               parse     ( const std::string& expression ); // EBM string parser (postfix).
            void               display   ( std::ostream& );                 // Display EBM string 
            unsigned int       litterals ();                                // Returns number of litterals 
            ValueType          eval      ();                                // Returns the logic value
            std::set<EbmVar*>  support   ();                                // Returns the support (set of variables)
            void               support   ( std::ostream& );                 // Display support string
};


inline std::ostream& operator<< ( std::ostream& o, Ebm* e )
{ e->display(o); return o; }


ValueType  NotTable ( ValueType );
ValueType  AndTable ( ValueType, ValueType );
ValueType  XorTable ( ValueType, ValueType );
ValueType   OrTable ( ValueType, ValueType );


#endif  // __EBM_H__
