
#include  "Indentation.h"

// ...

string  Lofig::modeToString ( unsigned int mode )
{
  switch ( mode ) {
    case Full:     return "Full";
    case Abstract: return "Abstract";
    case Empty:    return "Empty";
  }
  return "Unknown";
}


void  Lofig::xmlDrive ( ostream& o, unsigned int mode )
{
  o << indent++ << "<Lofig";
  o << " name=\"" << _name << "\"";
  o << " mode=\"" << modeToString(_mode) << "\"";
  o << " signalsIds=\"" << _signalIds << "\">\n";

  o << indent++ << "<signals>\n";
  for ( list<Losig*>::iterator isig=_signals.begin() ; isig!=_signals.end() ; isig++ )
    (*isig)->xmlDrive ( o );
  o << --indent << "</signals>\n";

  o << indent++ << "<connectors>\n";
  for ( list<Locon*>::iterator icon=_connectors.begin() ; icon!=_connectors.end() ; icon++ )
    (*icon)->xmlDrive ( o );
  o << --indent << "</connectors>\n";

  if ( mode == Full ) {
    o << indent++ << "<models>\n";
    for ( list<Lofig*>::iterator ifig=_models.begin() ; ifig!=_models.end() ; ifig++ )
      (*ifig)->xmlDrive ( o, Abstract );
    o << --indent << "</models>\n";

    o << indent++ << "<instances>\n";
    for ( list<Loins*>::iterator iins=_instances.begin() ; iins!=_instances.end() ; iins++ )
      (*iins)->xmlDrive ( o );
    o << --indent << "</instances>\n";
  }

  o << --indent << "</Lofig>\n";
}
