
INC_DIR           = .
OBJ_DIR           = .
SRC_DIR           = .

CORIOLIS_TOP      = /dsk/l1/jpc/coriolis-2.x/Linux.slsoc6x/Release.Shared/install
CORIOLIS_INCLUDES = -I$(CORIOLIS_TOP)/include/coriolis2
CORIOLIS_LIBS     = -L$(CORIOLIS_TOP)/lib \
                    -lcrlcore             \
                    -lisobar              \
                    -lviewer              \
                    -lhurricane           \
                    -lconfiguration
QT_INCLUDES       = -DQT_DLL -DQT_GUI_LIB -DQT_XML_LIB -DQT_CORE_LIB -DQT_NO_DEBUG \
                    -I/usr/include/QtGui  \
                    -I/usr/include/QtXml  \
                    -I/usr/include/QtCore
QT_LIBS           = -lQtGui -lpng -lSM -lICE -lXi -lXrender -lXrandr -lXcursor \
                    -lXinerama -lXfixes -lfreetype -lfontconfig -lXext -lX11 -lm \
                    -lQtXml -lQtCore -lz -lgthread-2.0 -lglib-2.0 -lrt -lpthread -ldl

VIEWER_INCLUDES   = $(CORIOLIS_INCLUDES) $(QT_INCLUDES)
VIEWER_INCS       = $(INC_DIR)/MbkBridge.h $(INC_DIR)/RawViewer.h
VIEWER_OBJS       = $(OBJ_DIR)/MbkBridge.o $(OBJ_DIR)/moc_RawViewer.o $(OBJ_DIR)/RawViewer.o
VIEWER_LIBS       = $(CORIOLIS_LIBS) $(QT_LIBS)


$(OBJ_DIR)/MbkBridge.o: $(INC_DIR)/Lofig.h $(SRC_DIR)/MbkBridge.cpp
	g++ $(CPPFLAGS) $(CORIOLIS_INCLUDES) $(QT_INCLUDES) -c $(SRC_DIR)/MbkBridge.cpp -o $@

$(OBJ_DIR)/RawViewer.o: $(INC_DIR)/RawViewer.h $(SRC_DIR)/RawViewer.cpp
	g++ $(CPPFLAGS) $(CORIOLIS_INCLUDES) $(QT_INCLUDES) -c $(SRC_DIR)/RawViewer.cpp -o $@

$(OBJ_DIR)/moc_RawViewer.o: $(SRC_DIR)/RawViewer.cxx
	g++ $(CPPFLAGS) $(CORIOLIS_INCLUDES) $(QT_INCLUDES) -c $(SRC_DIR)/RawViewer.cxx -o $@

$(SRC_DIR)/%.cxx: $(INC_DIR)/%.h
	moc-qt4 $(CORIOLIS_INCLUDES) $(QT_INCLUDES) -o $(SRC_DIR)/$*.cxx $(INC_DIR)/$*.h
