
#include  "Indentation.h"

/// ...

std::string  Locon::typeToString ( unsigned int type )
{
  switch ( type ) {
    case Internal: return "Internal";
    case External: return "External";
  }
  return "Unknown";
}


std::string  Locon::dirToString ( unsigned int direction )
{
  switch ( direction ) {
    case In:       return "In";
    case Out:      return "Out";
    case Inout:    return "Inout";
    case Tristate: return "Tristate";
    case Transcv:  return "Transcv";
  }
  return "Unknown";
}


void  Locon::xmlDrive ( std::ostream& o )
{
  o << indent << "<Locon name=\"" << _name << "\"";
  o << " signal=\"" << ((_signal != NULL) ? _signal->getName() : "NULL") << "\"";
  if ( _type == External ) o << " model=\""    << getModel   ()->getName() << "\"";
  else                     o << " instance=\"" << getInstance()->getName() << "\"";
  o << " dir=\"" << dirToString(_direction) << "\"";
  o << " type=\"" << typeToString(_type)  << "\"/>\n";
}
