

#include <string>
#include <sstream>
#include <iostream>
using namespace std;

#include "Library.h"


int  main ( int argc, char* argv )
{
  Lofig* halfadder = new Lofig ( "halfadder" );

  halfadder->addSignal ( "a"   , Locon::External );
  halfadder->addSignal ( "b"   , Locon::External );
  halfadder->addSignal ( "sout", Locon::External );
  halfadder->addSignal ( "cout", Locon::External );

  halfadder->addConnector ( "a"   , Locon::In , halfadder->findSignal("a"   ) );
  halfadder->addConnector ( "b"   , Locon::In , halfadder->findSignal("b"   ) );
  halfadder->addConnector ( "sout", Locon::Out, halfadder->findSignal("sout") );
  halfadder->addConnector ( "cout", Locon::Out, halfadder->findSignal("cout") );

  halfadder->addInstance ( Library::getModel(Library::Xor2), "xor" );
  Loins* inst_xor = halfadder->findInstance ( "xor" );
  inst_xor->connect ( "i0" , halfadder->findSignal("a"   ) );
  inst_xor->connect ( "i1" , halfadder->findSignal("b"   ) );
  inst_xor->connect ( "q"  , halfadder->findSignal("sout") );

  halfadder->addInstance ( Library::getModel(Library::And2), "and" );
  Loins* inst_and = halfadder->findInstance ( "and" );
  inst_and->connect ( "i0" , halfadder->findSignal("a"   ) );
  inst_and->connect ( "i1" , halfadder->findSignal("b"   ) );
  inst_and->connect ( "q"  , halfadder->findSignal("cout") );

  halfadder->setMode ( Lofig::Full );

// Full Adder description goes here.


  fulladder->xmlDrive ( cout );

  Lofig::destroyAll ();
  Library::destroy ();

  return 0;
}
