
// -*- C++ -*-

#include  <QtGui>
#if (QT_VERSION >= QT_VERSION_CHECK(4,5,0)) and not defined (__APPLE__)
#  include  <QGtkStyle>
#endif

#include "hurricane/viewer/CellWidget.h"
#include "hurricane/viewer/Graphics.h"
#include "hurricane/viewer/HApplication.h"
#include "crlcore/AllianceFramework.h"
#include "MbkBridge.h"
#include "RawViewer.h"

using Hurricane::dbo_ptr;
using Hurricane::Error;
using Hurricane::Cell;
using Hurricane::HApplication;
using Hurricane::Graphics;
using CRL::AllianceFramework;


RawViewer::RawViewer ( QWidget* parent )
  : CellViewer(parent)
{ }


RawViewer::~RawViewer ()
{ }


RawViewer* RawViewer::create ( QWidget* parent )
{
  RawViewer* rawviewer = new RawViewer ( parent );
  rawviewer->_postCreate ();
  return rawviewer;
}


void  RawViewer::destroy ()
{
  _preDestroy ();
  delete this;
}


void  RawViewer::_postCreate ()
{
  setApplicationName ( tr("rawviewer") );
}


void  RawViewer::_preDestroy ()
{ }


void  RawViewer::run ( int argc, char* argv[], Cell* cell )
{
  int   returnCode = 0;

  try {
    dbo_ptr <AllianceFramework> af ( AllianceFramework::create() );
    auto_ptr<QApplication>      qa ( new HApplication(argc,argv) );
#if (QT_VERSION >= QT_VERSION_CHECK(4,5,0)) and not defined (__APPLE__)
    qa->setStyle ( new QGtkStyle() );
#endif
    Graphics::enable ();

    dbo_ptr<RawViewer> viewer ( RawViewer::create() );
    viewer->setCell ( cell );
    viewer->show();
    returnCode = qa->exec();
  }
  catch ( Error& e ) {
    cerr << e.what() << endl;
    exit ( 1 );
  }
  catch ( exception& e ) {
    cerr << "[ERROR] " << e.what() << endl;
    exit ( 1 );
  }
  catch ( ... ) {
    cout << "[ERROR] Abnormal termination: unmanaged exception.\n" << endl;
    exit ( 2 );
  }
}
