
#include  "LogicValue.h"


LogicValue::LogicValue ()
  : _value(Zero)
{ }


LogicValue::LogicValue ( int value )
  : _value(Undefined)
{ fromInt(value); }


LogicValue::~LogicValue ()
{ }


void  LogicValue::print ( std::ostream& o ) const
{
  switch ( _value ) {
    case Zero:      o << '0'; break;
    case One:       o << '1'; break;
    default:
    case Undefined: o << 'U'; break;
  }
}


int  LogicValue::toInt () const
{ return (int)_value; }


void  LogicValue::fromInt ( int value )
{
  switch ( value ) {
    case 0:  _value = Zero;      break;
    case 1:  _value = One;       break;
    default:
    case 2:  _value = Undefined; break;
  }
}


LogicValue  operator not ( const LogicValue& v )
{
  if ( v == LogicValue::Zero ) return LogicValue::One;
  if ( v == LogicValue::One  ) return LogicValue::Zero;
  return LogicValue::Undefined;
}


LogicValue  operator and ( const LogicValue& lhs, const LogicValue& rhs )
{
  if ( (lhs == LogicValue::Zero) or (rhs == LogicValue::Zero) )
    return LogicValue::Zero;

  if ( (lhs == LogicValue::Undefined) or (rhs == LogicValue::Undefined) )
    return LogicValue::Undefined;

  return LogicValue::One;
}


LogicValue  operator or ( const LogicValue& lhs, const LogicValue& rhs )
{
  if ( (lhs == LogicValue::One) or (rhs == LogicValue::One) )
    return LogicValue::One;

  if ( (lhs == LogicValue::Undefined) or (rhs == LogicValue::Undefined) )
    return LogicValue::Undefined;

  return LogicValue::Zero;
}


LogicValue  operator xor ( const LogicValue& lhs, const LogicValue& rhs )
{
  LogicValue result;

  if ( (lhs == LogicValue::Undefined) or (rhs == LogicValue::Undefined) )
    return LogicValue::Undefined;
  else if ( lhs == rhs )
    return LogicValue::Zero;

  return LogicValue::One;
}


bool  operator == ( const LogicValue& lhs, const LogicValue& rhs )
{ return lhs._value == rhs._value; }


bool  operator != ( const LogicValue& lhs, const LogicValue& rhs )
{ return lhs._value != rhs._value; }
