
#include  <iostream>
#include  "EbmVar.h"
#include  "EbmExpr.h"
using namespace std;


void  printTruthTable ( Ebm* e )
{
  if ( e == NULL ) {
    cerr << "[ERROR] Argument Ebm* musn't be NULL." << endl;
    return;
  }

  cout << "  Truth Table of:\n    " << e << endl;
  cout << "    Support is: "; e->support(cout); cout << endl;

  const set<EbmVar*>& support = e->support();

  cout << "    ";
  for ( set<EbmVar*>::const_iterator ivar=support.begin() ; ivar != support.end() ; ++ivar )
    cout << (*ivar)->getName();
  cout << " | e" << endl;

  unsigned int tableSize = 2 << (support.size()-1);
  for ( unsigned int entries=0 ; entries < tableSize ; ++entries ) {
    cout << "    ";
    size_t i=support.size()-1;
    for ( set<EbmVar*>::const_iterator ivar=support.begin() ; ivar != support.end() ; ++ivar, --i ) {
      unsigned int entry = (entries >> i) % 2;
      (*ivar)->setValue( entry );
      cout << entry;
    }
    cout << " | " << e->eval() << endl;
  }
}


int main ( int argc, char* argv[] )
{
  Ebm*  a  = EbmVar::create ( "a" );
  Ebm*  b  = EbmVar::create ( "b" );
  Ebm*  c  = EbmVar::create ( "c" );

  Ebm* na = EbmExpr::Not ( a );
  Ebm* nb = EbmExpr::Not ( b );
  Ebm* nc = EbmExpr::Not ( c );

  Ebm* e0 = EbmExpr::And ( a,  b,  c );
  Ebm* e1 = EbmExpr::And ( a,  b, nc );
  Ebm* e2 = EbmExpr::And ( a, nb,  c );
  Ebm* e3 = EbmExpr::And (na,  b,  c );
  Ebm* e4 = EbmExpr::Or  ( e0, e1, e2, e3 );

  printTruthTable(e4);

  Ebm* e5 = Ebm::parse("(a.b)+(a.c)+(b.c)");
  printTruthTable(e5);

#if 0
  cout << "e10 = " << Ebm::parse ( "(a . b . c) + (a . b . c') + (a . b' . c) + (a' .b . c)" ) << endl;
  cout << "e11 = " << Ebm::parse ( "(x1.x2) + (x1.x3)" ) << endl;
  cout << "e12 = " << Ebm::parse ( "((var1 + var2).var3 ) + var4" ) << endl;
  cout << "e13 = " << Ebm::parse ( "(a . b)'" ) << endl;
  cout << "e13 = " << Ebm::parse ( "a'" ) << endl;
#endif

// This is it!
  return 0;
}
