
#include  <string>
#include  "BoolValue.h"


BoolValue::BoolValue ()
  : _value(Zero)
{ }


BoolValue::BoolValue ( int value )
  : _value(Zero)
{ fromInt(value); }


BoolValue::~BoolValue ()
{ }


void  BoolValue::print ( std::ostream& o ) const
{
  switch ( _value ) {
    case Zero:      o << '0'; break;
    case One:       o << '1'; break;
    case Undefined: o << 'U'; break;
  }
}


int  BoolValue::toInt () const
{ return _value; }


void  BoolValue::fromInt ( int value )
{
  switch ( value ) {
    default:
    case 0:  _value = Zero;      break;
    case 1:  _value = One;       break;
    case 2:  _value = Undefined; break;
  }
}


BoolValue  operator not ( const BoolValue& v )
{
  if ( v == BoolValue::Zero ) return BoolValue::One;
  if ( v == BoolValue::One  ) return BoolValue::Zero;
  return BoolValue::Undefined;
}


BoolValue  operator and ( const BoolValue& lhs, const BoolValue& rhs )
{
  if ( (lhs == BoolValue::Zero) or (rhs == BoolValue::Zero) )
    return BoolValue::Zero;

  if ( (lhs == BoolValue::Undefined) or (rhs == BoolValue::Undefined) )
    return BoolValue::Undefined;

  return BoolValue::One;
}


BoolValue  operator or ( const BoolValue& lhs, const BoolValue& rhs )
{
  if ( (lhs == BoolValue::One) or (rhs == BoolValue::One) )
    return BoolValue::One;

  if ( (lhs == BoolValue::Undefined) or (rhs == BoolValue::Undefined) )
    return BoolValue::Undefined;

  return BoolValue::Zero;
}


BoolValue  operator xor ( const BoolValue& lhs, const BoolValue& rhs )
{
  BoolValue result;

  if ( (lhs == BoolValue::Undefined) or (rhs == BoolValue::Undefined) )
    return BoolValue::Undefined;

  else if ( lhs == rhs )
    return BoolValue::Zero;

  return BoolValue::One;
}


bool  operator == ( const BoolValue& lhs, const BoolValue& rhs )
{
  return lhs._value == rhs._value;
}
