
#include  <cstdlib>
using namespace std;

#include  "Ebm.h"
#include  "EbmVar.h"
#include  "EbmExpr.h"


void  _lexer ( const string& expression, vector<string>& tokens )
{
  string work;

// First: remove all white spaces.
  for ( size_t i=0 ; i<expression.size() ; ++i ) {
    switch ( expression[i] ) {
      case ' ':
      case '\n':
      case '\t':
        continue;
    }
    work += expression[i];
  }

// Second: tokenize, special characters being "().+'".
  size_t tokenStart  = 0;
  size_t tokenLength = 1;
  for ( size_t i=0 ; i<work.size() ; ++i, ++tokenLength ) {
    switch ( work[i] ) {
      case '(':
      case ')':
      case '.':
      case '+':
      case '^':
      case '\'':
      // The previous token (has to be a variable name).
        if ( tokenLength > 1 )
          tokens.push_back ( work.substr(tokenStart,tokenLength-1) );
     // The special token itself.
        tokens.push_back ( work.substr(i,1) );

        tokenStart  = i+1;
        tokenLength = 0;
    }
  }
  if ( tokenLength > 1 )
    tokens.push_back ( work.substr(tokenStart,tokenLength-1) );
}


Ebm* _parse ( vector<string>& tokens, size_t& position )
{
  if ( position >= tokens.size() ) {
    cerr << "[ERROR] Bad expression syntax." << endl;
    exit (1);
  }

  Ebm::OperatorType opType = Ebm::UndefinedOperator;
  list<Ebm*>        operands;

  do {
    if ( tokens[position] == "." ) {
    // And Operator.
      if ( (opType == Ebm::UndefinedOperator) or (opType == Ebm::And) ) {
        opType = Ebm::And;
      } else {
        cerr << "[ERROR] Associativity not managed in expressions." << endl;
      }
    } else if ( tokens[position] == "+" ) {
    // Or Operator.
      if ( (opType == Ebm::UndefinedOperator) or (opType == Ebm::Or) ) {
        opType = Ebm::Or;
      } else {
        cerr << "[ERROR] Associativity not managed in expressions." << endl;
      }
    } else if ( tokens[position] == "^" ) {
    // Or Operator.
      if ( (opType == Ebm::UndefinedOperator) or (opType == Ebm::Xor) ) {
        opType = Ebm::Xor;
      } else {
        cerr << "[ERROR] Associativity not managed in expressions." << endl;
      }
    } else if ( tokens[position] == "\'" ) {
    // Negation Operator (apply immediatly on last operand).
      if ( operands.empty() ) {
        cerr << "[ERROR] Misplaced negate operator (ignored)." << endl;
      } else {
        Ebm* operand = operands.back();
        operands.pop_back ();
        operands.push_back ( EbmExpr::Not(operand) );
      }
    } else if ( tokens[position] == "(" ) {
    // We are entering a new level: recursive call.
      Ebm* expression = _parse ( tokens, ++position );
      if ( expression ) operands.push_back ( expression );
    } else if ( tokens[position] == ")" ) {
    // The current level is finished: exit the loop.
      break;
    } else {
    // Only remaining case: a variable.
      operands.push_back ( EbmVar::create(tokens[position]) );
    }

  } while ( ++position < tokens.size() );

  if ( operands.empty() ) {
    cerr << "[ERROR] Empty expression." << endl;
    return NULL;
  }
  if ( (operands.size() == 1) and (opType == Ebm::UndefinedOperator) )
    return operands.front();

  return new EbmExpr ( opType, operands );
}


Ebm* Ebm::parse ( const string& expression )
{
  size_t         position = 0;
  vector<string> tokens;

  _lexer ( expression, tokens );
  return _parse ( tokens, position );
}
