
#ifndef  __LOGICVALUE_H__
#define  __LOGICVALUE_H__

#include  <iostream>


class LogicValue {
  public:
    enum Value { Zero=0, One=1, Undefined=2 };
  public:
          LogicValue ();
          LogicValue ( int );
         ~LogicValue ();
    void  print      ( std::ostream& ) const;
    int   toInt      () const;
    void  fromInt    ( int );
  private:
    Value  _value;

    friend bool  operator == ( const LogicValue& lhs, const LogicValue& rhs );
    friend bool  operator != ( const LogicValue& lhs, const LogicValue& rhs );
};


LogicValue  operator not ( const LogicValue& lhs );
LogicValue  operator and ( const LogicValue& lhs, const LogicValue& rhs );
LogicValue  operator or  ( const LogicValue& lhs, const LogicValue& rhs );
LogicValue  operator xor ( const LogicValue& lhs, const LogicValue& rhs );
bool        operator ==  ( const LogicValue& lhs, const LogicValue& rhs );
bool        operator !=  ( const LogicValue& lhs, const LogicValue& rhs );

inline std::ostream& operator<< ( std::ostream& o, const LogicValue& v ) { v.print(o); return o; } 

#endif  // __LOGICVALUE_H__
