
#ifndef  __BOOLVALUE_H__
#define  __BOOLVALUE_H__

#include  <iostream>


class BoolValue {
  public:
    enum Value { Zero=0, One=1, Undefined=2 };
  public:
          BoolValue ();
          BoolValue ( int );
         ~BoolValue ();
    void  print     ( std::ostream& ) const;
    int   toInt     () const;
    void  fromInt   ( int );
  private:
    int  _value;

    friend bool  operator == ( const BoolValue& lhs, const BoolValue& rhs );
};


BoolValue  operator not ( const BoolValue& lhs );
BoolValue  operator and ( const BoolValue& lhs, const BoolValue& rhs );
BoolValue  operator or  ( const BoolValue& lhs, const BoolValue& rhs );
BoolValue  operator xor ( const BoolValue& lhs, const BoolValue& rhs );
bool       operator ==  ( const BoolValue& lhs, const BoolValue& rhs );

inline std::ostream& operator<< ( std::ostream& o, const BoolValue& v ) { v.print(o); return o; } 

#endif  // __BOOLVALUE_H__
