
#ifndef  __BDD_H__
#define  __BDD_H__

#include  <string> 
#include  <iostream> 
#include  <map>


class Ebm;


class Bdd {
  public:
    class Key {
      private:
               unsigned int _index;
               unsigned int _highIdent;
               unsigned int _lowIdent;
      public:
        inline              Key       ( unsigned int index, unsigned int high, unsigned int low );
        friend bool         operator< ( const Key& lhs, const Key& rhs );
    };
  private:
    static unsigned int       _maxIdent;
    static unsigned int       _maxStamp;
    static std::map<Key,Bdd*> _bdds;
  private:
           unsigned int       _ident;    // Unicity identifier.
           unsigned int       _index;    // Decomposition variable index.
           Bdd*               _high;     // Low cofactor pointer.
           Bdd*               _low;      // High cofactor pointer.
           unsigned           _stamp;    // Used to flag already reached nodes in the DAG recursive walktrhough.
  public:                     
    static Bdd*               One;
    static Bdd*               Zero;
  private:                    
                              Bdd          ( unsigned index, Bdd* high, Bdd* low );  
                             ~Bdd          ();  
  public :                                 
    static Bdd*               create       ( unsigned index, Bdd* high, Bdd* low );
    static Bdd*               apply        ( Ebm::OperatorType, Bdd*, Bdd* );
    static Bdd*               Not          ( Bdd* );
    static Bdd*               And          ( Bdd*, Bdd* );
    static Bdd*               And          ( Bdd*, Bdd*, Bdd* );
    static Bdd*               And          ( Bdd*, Bdd*, Bdd*, Bdd* );
    static Bdd*               Xor          ( Bdd*, Bdd* );
    static Bdd*               Xor          ( Bdd*, Bdd*, Bdd* );
    static Bdd*               Xor          ( Bdd*, Bdd*, Bdd*, Bdd* );
    static Bdd*               Or           ( Bdd*, Bdd* );
    static Bdd*               Or           ( Bdd*, Bdd*, Bdd* );
    static Bdd*               Or           ( Bdd*, Bdd*, Bdd*, Bdd* );
  public:                                  
    inline unsigned           getIdent     ();
    inline unsigned           getIndex     ();
    inline Bdd*               getHigh      ();
    inline Bdd*               getLow       ();
           Bdd*               neg          ();
           unsigned int       depth        ();
           Bdd*               satisfy      ();
           void               display      ( std::ostream& );
           void               toDot        ( const string& filename );
           void               toDot        ( std::ostream& );
           BoolValue          eval         ();
           Ebm*               toEbm        ();
    static Bdd*               fromEbm      ( Ebm* );
  private:                    
    inline Key                _getKey      ();
           void               _display     ( std::ostream& );
           void               _toDot       ( std::ostream& );
    friend std::ostream&      operator<<   ( std::ostream&, const Bdd* );
};


// Bdd inline methods.
inline unsigned int       Bdd::getIdent   () { return _ident; }
inline unsigned int       Bdd::getIndex   () { return _index; }
inline Bdd*               Bdd::getHigh    () { return _high; }
inline Bdd*               Bdd::getLow     () { return _low; }

inline Bdd::Key  Bdd::_getKey ()
{
  return Key ( _index
             , (_high == NULL) ? 0 : _high->_index
             , (_low  == NULL) ? 0 : _low ->_index );
}


// Bdd::Key inline method.
inline Bdd::Key::Key ( unsigned int index, unsigned int high, unsigned int low )
  : _index    (index)
  , _highIdent(high)
  , _lowIdent (low)
{ }


inline bool  operator< ( const Bdd::Key& lhs, const Bdd::Key& rhs )
{
// Uses lexicographical order (_index,_lowId,_highId).
  if ( lhs._index != rhs._index )
    return ( lhs._index < rhs._index );

  if ( lhs._lowIdent != rhs._lowIdent )
    return ( lhs._lowIdent < rhs._lowIdent );

  return ( lhs._highIdent < rhs._highIdent );
}


#endif  // __BDD_H__
