
#include  <stdlib.h>
#include  <iostream>
#include  <iomanip>
#include  <sstream>
#include  <fstream>
using namespace std;

#include  "Indentation.h"
#include  "EbmVar.h"
#include  "EbmExpr.h"
#include  "Bdd.h"




Bdd* Bdd::apply ( Ebm::OperatorType oper, Bdd* bdd1, Bdd* bdd2 ) 
{
  if ( (bdd1 == NULL) or (bdd2 == NULL) ) {
    cout << "[ERROR] Bdd::apply(): NULL pointer argument." << endl;
    exit(1);
  }
  if ( (oper != Ebm::And) and (oper != Ebm::Or) and (oper != Ebm::Xor) ) {
    cout << "[ERROR] Bdd::apply(): illegal operator." << endl;
    exit (1);
  }

// Normalize index order: lower index always in "bdd1".  
// Constants will always be in "bdd1".
  if ( bdd2->getIndex() < bdd1->getIndex() ) {
    Bdd* swap = bdd1; bdd1 = bdd2; bdd2 = swap;
  }
    
  if ( bdd1 == One ) {
  // bdd1 is "High" (one) constant.
    switch ( oper ) {
      case Ebm::And: return bdd2;
      case Ebm::Or : return bdd1;
      case Ebm::Xor: return bdd2->neg();
      case Ebm::Not:
      case Ebm::UndefinedOperator:
        return bdd1;
    }
  }

  if ( bdd1 == Zero ) {
  // bdd1 is "Low" (zero) constant.
    switch ( oper ) {
      case Ebm::And: return bdd1;
      case Ebm::Or : return bdd2;
      case Ebm::Xor: return bdd2;
      case Ebm::Not:
      case Ebm::UndefinedOperator:
        return bdd1;
    }
  }

// General case: index(bdd1) == index(bdd2)
// That is: bdd1 & bdd2 belongs to the same variable.
  if ( bdd1->getIndex() == bdd2->getIndex() ) {
    return Bdd::create ( bdd1->getIndex()
                       , apply ( oper, bdd1->getHigh(), bdd2->getHigh() )
                       , apply ( oper, bdd1->getLow (), bdd2->getLow () )
                       );
  }

  // General case: index(bdd1) < index(bdd2)
  return Bdd::create ( bdd2->getIndex()
                     , apply ( oper, bdd1, bdd2->getHigh() )
                     , apply ( oper, bdd1, bdd2->getLow () )
                     );
}


Bdd* Bdd::neg () 
{
  switch ( _index ) {
    case 0: return One;
    case 1: return Zero;
  }
  return create ( _index, _high->neg(), _low->neg() );
}


Bdd* Bdd::Not ( Bdd* bdd1 )
{ return bdd1->neg(); }


Bdd* Bdd::And ( Bdd* bdd1, Bdd* bdd2 )
{ return apply(Ebm::And,bdd1,bdd2); }


Bdd* Bdd::And ( Bdd* bdd1, Bdd* bdd2, Bdd* bdd3 )
{ return And ( bdd3, And(bdd1,bdd2) ); }


Bdd* Bdd::And ( Bdd* bdd1, Bdd* bdd2, Bdd* bdd3, Bdd* bdd4 )
{ return And ( bdd4, And ( bdd3, And(bdd1,bdd2) ) ); }


Bdd* Bdd::Xor ( Bdd* bdd1, Bdd* bdd2 )
{ return apply(Ebm::Xor,bdd1,bdd2); }


Bdd* Bdd::Xor ( Bdd* bdd1, Bdd* bdd2, Bdd* bdd3 )
{ return Xor ( bdd3, Xor(bdd1,bdd2) ); }


Bdd* Bdd::Xor ( Bdd* bdd1, Bdd* bdd2, Bdd* bdd3, Bdd* bdd4 )
{ return Xor ( bdd4, Xor ( bdd3, Xor(bdd1,bdd2) ) ); }


Bdd* Bdd::Or ( Bdd* bdd1, Bdd* bdd2 )
{ return apply(Ebm::Or,bdd1,bdd2); }


Bdd* Bdd::Or ( Bdd* bdd1, Bdd* bdd2, Bdd* bdd3 )
{ return Or ( bdd3, Or(bdd1,bdd2) ); }


Bdd* Bdd::Or ( Bdd* bdd1, Bdd* bdd2, Bdd* bdd3, Bdd* bdd4 )
{ return Or ( bdd4, Or ( bdd3, Or(bdd1,bdd2) ) ); }


void  Bdd::display ( ostream& out )
{
  ++_maxStamp;
  _display ( out );
}




void  Bdd::toDot ( const string& filename )
{
  ostringstream path;
  path << filename << ".dot";
  ofstream file ( path.str().c_str() );
  toDot ( file );
  file.close ();

  ostringstream command;
  command << "dot -Tpng " << filename << ".dot > " << filename << ".png";
  system ( command.str().c_str() );
}


void  Bdd::toDot ( ostream& out )
{
  ++_maxStamp;

  out << "digraph BDD {" << endl;
  out << "  ratio=1.0;" << endl;
  _toDot ( out );
  out << "}" << endl;
}


void  Bdd::_toDot ( ostream& out )
{
  if ( _stamp >= _maxStamp ) {
  //if      ( _index == 0 ) { out << "  n0 [shape=box,label=\"Zero\"];" << endl; }
  //else if ( _index == 1 ) { out << "  n1 [shape=box,label=\"One\"];" << endl; }
    return;
  }
  _stamp = _maxStamp;

  if ( _index == 0 ) {
    out << "  n0 [shape=box,label=\"Zero\"];" << endl;
  } else if ( _index == 1 ) {
    out << "  n1 [shape=box,label=\"One\"];" << endl;
  } else {
    string         name     = EbmVar::get(_index)->getName();
    ostringstream  nodename;
    nodename << "n" << _ident;

    out << "  " << nodename.str() << " [label=\"\\N\\n" << name << "\",fontname=\"Bitstream Vera Sans\"];" << endl;
    out << "  " << nodename.str() << " -> " << "n" << _high->getIdent()
        << "[label=\"H\",color=red]" << ";" << endl;
    out << "  " << nodename.str() << " -> " << "n" << _low ->getIdent()
        << "[label=\"L\",color=blue]" << ";" << endl;

    _high->_toDot ( out );
    _low ->_toDot ( out );
  }
}




BoolValue  Bdd::eval ()
{
  if ( _index == 0 ) return BoolValue::Zero;
  if ( _index == 1 ) return BoolValue::One;

  BoolValue FH = _high->eval ();
  BoolValue FL =  _low->eval ();
  BoolValue  x = EbmVar::get(_index)->getValue();

// The Shannon decomposition.
  return (x and FH) or ((not x) and FL);
}

ostream& operator<< ( ostream& o, const Bdd* bdd )
{
  if      ( bdd->_index == 0 ) { o << "Bdd( Zero )"; }
  else if ( bdd->_index == 1 ) { o << "Bdd( One )"; }
  else {
    o << "Bdd( [" << bdd->_ident
      << "] idx:" << bdd->_index
      << " high:" << bdd->_high->_ident
      << " low:"  << bdd->_low ->_ident
      << " )";
  }
  return o;
}
