
#ifndef  __EBMVAR_H__
#define  __EBMVAR_H__

#include  <string> 
#include  <map> 
#include  "Ebm.h"


class EbmVar: public Ebm {
  private:
    static unsigned int                    _maxIndex;
    static std::map<std::string ,EbmVar*>  _byName;   // All variables storage.
    static std::map<unsigned int,EbmVar*>  _byIndex;
  private :    
             std::string   _name;       // Variable name.
             LogicValue    _value;      // Logical value.
             unsigned int  _index;      // Unique index (for ROBDD)
  private:
                           EbmVar   ( std::string name, LogicValue value=LogicValue::Zero );
    virtual               ~EbmVar   ();
  public:
    static   EbmVar*       create   ( std::string name, LogicValue value=LogicValue::Zero );
  public:
    virtual  Ebm::Type     getType  ();
    inline   std::string   getName  ();
    inline   LogicValue    getValue ();
    inline   unsigned int  getIndex ();
    inline   void          setValue ( LogicValue value );
  // Operations sur le dictionnaire
    static   EbmVar*       get      ( unsigned int index );
    static   EbmVar*       get      ( std::string name );
};


inline   std::string   EbmVar::getName  () { return _name; }
inline   LogicValue    EbmVar::getValue () { return _value; }
inline   unsigned int  EbmVar::getIndex () { return _index; }
inline   void          EbmVar::setValue ( LogicValue value ) { _value=value; }


#endif   // __EBMVAR_H__
