
#ifndef __PROCESS_H__
#define __PROCESS_H__

#include  <string>
#include  <iostream>

#include  "LogicValue.h"
class Ebm;
class Signal;
class BoolNet;


class Process {
  private:
    BoolNet*      _network;
    Signal*       _signal;
    Ebm*          _expression;
    unsigned int  _delay;
  public:
                         Process       ( BoolNet*, Signal*, const std::string& expression, unsigned int delay=0 );
           LogicValue    eval          ();
    inline Ebm*          getExpression ();
    inline Signal*       getSignal     ();
    inline unsigned int  getDelay      ();
           void          display       ( std::ostream& );
           std::string   toString      ();
};


inline Ebm*          Process::getExpression () { return _expression; }
inline Signal*       Process::getSignal     () { return _signal; }
inline unsigned int  Process::getDelay      () { return _delay; }


#endif  // __PROCESS_H__
