
#include  <iostream>
#include  <sstream>
#include  <fstream>
#include  <iomanip>

#include  "Process.h"
#include  "BoolNet.h"
#include  "Event.h"
#include  "Scheduler.h"

using namespace std;


string  signalTypeToString ( Signal::Type type )
{
  switch ( type ) {
    case Signal::In:       return "in";
    case Signal::Out:      return "out";
    case Signal::Internal: return "signal";
    default: break;
  }
  return "undefined";
}


// A completer.


void  Scheduler::_reset ()
{
  vector<Signal*>& signals = _network->getSignals();

  for ( size_t i=0 ; i<signals.size() ; ++i ) {
    signals[i]->setValue ( LogicValue::Undefined );
  }
}


void  Scheduler::_header ()
{
  vector<Signal*>& signals = _network->getSignals();

  cout << setw(3) << "Tm" << ":dt|";

  for ( size_t i=0 ; i<signals.size() ; ++i ) {
    cout << " " << setw(4) << signals[i]->getName();
  }

  cout << endl;
}


void  Scheduler::_display ( const Date& date )
{
  vector<Signal*>& signals = _network->getSignals();

  cout << setw(3) << date.getTime() << ":" << date.getDelta() << " |";

  for ( size_t i=0 ; i<signals.size() ; ++i ) {
    cout << " " << setw(4) << signals[i]->getValue();
  }

  cout << endl;
}


void  Scheduler::toPatterns ( ostream& out )
{
  vector<Signal*>& signals = _network->getSignals();

  for ( size_t i=0 ; i<signals.size() ; ++i ) {
    out << setw(7) << left << signalTypeToString(signals[i]->getType())
        << " " << signals[i]->getName() << " ;" << endl;
  }

  out << "begin" << endl;

  _reset ();
  std::map<Date, std::vector<Event*> >::iterator  currentState = _events.begin();

  ostringstream line;

  for ( ; currentState != _events.end() ; ++currentState ) {
    const Date&     currentDate   = (*currentState).first;
    vector<Event*>& currentEvents = (*currentState).second;

  // Replay: update variables values.
    for ( size_t ievent=0 ; ievent < currentEvents.size() ; ++ievent )
      currentEvents[ievent]->updateSignalValue ();

    if ( (currentDate.getDelta() == 0) and (not line.str().empty()) ) {
    // First new delta cycle: dump the previous line.
      out << line.str() << endl;
    }

  // Generate the next line to print and buffer it.
    line.str("");
    line << "<" << setw(3) << right << currentDate.getTime() << "ns> :";

    for ( size_t i=0 ; i<signals.size() ; ++i ) {
      switch ( signals[i]->getType() ) {
        case Signal::In:
          line << " " << signals[i]->getValue();
          break;
        case Signal::Out:
        case Signal::Internal:
        default:
          line << " ?" << signals[i]->getValue();
      }
    }
    line << ";";
  }
  out << line.str() << endl;

  out << "end;" << endl;
}


void  Scheduler::toPatterns ()
{
  string   filename  = _network->getName() + ".pat";
  ofstream patstream ( filename.c_str() );
  toPatterns ( patstream );
  patstream.close ();
}
