
#include  <cstdlib>
#include  <fstream>

#include  "BoolNet.h"
#include  "Signal.h"
#include  "Process.h"

using namespace std;


// A completer.


void  BoolNet::toDot ( ostream& out )
{
  out << "digraph " << _name << " {" << endl;
  out << "  node [fontname=\"Bitstream-Vera-Sans-Mono\"];" << endl;

  for ( size_t i=0 ; i<_signals.size() ; ++i ) {
    out << "  " << _signals[i]->getName() << " [shape=box";
    switch ( _signals[i]->getType() ) {
      case Signal::In:       out << ",color=red";   break;
      case Signal::Out:      out << ",color=green"; break;
      case Signal::Internal: break;
    }
    out << "];" << endl;
    
    set<Process*>&          processes = _signals[i]->getProcesses();
    set<Process*>::iterator iprocess  = processes.begin();
    for ( ; iprocess != processes.end() ; ++iprocess ) {
      out << "  " << _signals[i]->getName() << " -> "
          << "\"" << (*iprocess)->toString() << "\";" << endl;
    }
  }

  for ( size_t i=0 ; i<_processes.size() ; ++i ) {
    out << "  \""   << _processes[i]->toString()
        << "\" -> " << _processes[i]->getSignal()->getName()
        << " [style=bold] ;" << endl;
  }

  out << "}";
}


void  BoolNet::toDot ()
{
  string   filename  = _name + ".dot";
  ofstream dotstream ( filename.c_str() );
  toDot ( dotstream );
  dotstream.close ();

  string command = "dot -Tpng " + filename + " > " + _name + ".png";
  system ( command.c_str() );
}
