
#ifndef  __SIGNAL_H__
#define  __SIGNAL_H__

#include  <string>
#include  <set>
#include  "EbmVar.h"

class Process;
class BoolNet;


class Signal {
  public:
    enum Type { In=1, Out, Internal };
  private:
    BoolNet*            _network;
    EbmVar*             _variable;
    Type                _type;
    std::set<Process*>  _processes;
  public:
                               Signal       ( BoolNet*, const std::string&, Type );
    inline std::string         getName      ();
    inline Type                getType      ();
    inline LogicValue          getValue     ();
    inline std::set<Process*>& getProcesses ();
    inline void                addProcess   ( Process* );
    inline void                setValue     ( LogicValue );
};


inline std::string         Signal::getName      () { return _variable->getName(); }
inline Signal::Type        Signal::getType      () { return _type; }
inline LogicValue          Signal::getValue     () { return _variable->getValue(); }
inline std::set<Process*>& Signal::getProcesses () { return _processes; }
inline void                Signal::addProcess   ( Process* process ) { _processes.insert(process); }
inline void                Signal::setValue     ( LogicValue value ) { _variable->setValue(value); }


#endif  // __SIGNAL_H__
